/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection.channel;

import com.mule.extensions.amqp.api.exception.AmqpAckException;
import com.mule.extensions.amqp.api.exception.AmqpDeliveryTagNotFoundException;
import com.mule.extensions.amqp.internal.connection.channel.ChannelInformation;
import com.mule.extensions.amqp.internal.connection.channel.TransactionInformation;
import com.mule.extensions.amqp.internal.connection.channel.TransactionStatus;
import com.mule.extensions.amqp.internal.message.AmqpMessage;
import com.rabbitmq.client.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpChannelManager.class);
    private final Map<String, ChannelInformation> pendingChannels = new HashMap<String, ChannelInformation>();
    private final Map<Integer, Integer> acksCountPendingChannels = new HashMap<Integer, Integer>();
    private final ThreadLocal<TransactionInformation> transactionInformation = new ThreadLocal();

    public void bindToTransaction(Channel channel) {
        this.getTransactionInformation().setChannel(channel);
    }

    public void registerMessageForAck(String ackId, AmqpMessage message, Channel channel) {
        if (!this.pendingChannels.containsKey(ackId)) {
            this.pendingChannels.put(ackId, new ChannelInformation(message, channel));
            Integer countPendingAcks = this.acksCountPendingChannels.get(channel.getChannelNumber());
            this.acksCountPendingChannels.put(channel.getChannelNumber(), countPendingAcks == null ? 1 : countPendingAcks + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered Message for Channel AckId [" + ackId + "]");
        }
    }

    public void ack(String ackId) throws AmqpAckException {
        block5: {
            Optional<ChannelInformation> optionalChannel = this.getChannelInformation(ackId);
            try {
                if (optionalChannel.isPresent()) {
                    Channel channel = optionalChannel.get().getChannel();
                    channel.basicAck(optionalChannel.get().getMessage().getEnvelope().getDeliveryTag(), false);
                    Integer countPendingAcks = this.acksCountPendingChannels.get(channel.getChannelNumber());
                    if (countPendingAcks == 1) {
                        this.acksCountPendingChannels.remove(channel.getChannelNumber());
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Acknowledged Message for Channel with AckId [" + ackId + "]");
                    }
                    break block5;
                }
                LOGGER.error("The channel could not be acknowledged. This may be due to: \n - The channel has been already acknowledged\n- The channel has been recovered\n - The given 'ackId' :  [" + ackId + "] is invalid.");
                throw new AmqpDeliveryTagNotFoundException("The channel for the manual acknowledge of the AckId provided was not found");
            }
            catch (Exception e) {
                throw new AmqpAckException("An error occurred during ack", e);
            }
        }
    }

    private Optional<ChannelInformation> getChannelInformation(String ackId) {
        return Optional.ofNullable(this.pendingChannels.remove(ackId));
    }

    public TransactionInformation getTransactionInformation() {
        TransactionInformation transactionInformation = this.transactionInformation.get();
        if (transactionInformation == null) {
            transactionInformation = new TransactionInformation();
            this.transactionInformation.set(transactionInformation);
        }
        return transactionInformation;
    }

    public void unbindChannel() {
        this.transactionInformation.remove();
    }

    public Optional<Channel> getTransactedChannel() {
        return Optional.ofNullable(this.getTransactionInformation().getChannel());
    }

    public TransactionStatus getTransactionStatus() {
        TransactionStatus transactionStatus = this.getTransactionInformation().getTransactionStatus();
        return transactionStatus != null ? transactionStatus : TransactionStatus.NONE;
    }

    public void changeTransactionStatus(TransactionStatus transactionStatus) {
        this.getTransactionInformation().setTransactionStatus(transactionStatus);
    }

    public void reject(String ackId, boolean requeue) {
        block4: {
            Optional<ChannelInformation> optionalChannel = this.getChannelInformation(ackId);
            try {
                if (optionalChannel.isPresent()) {
                    optionalChannel.get().getChannel().basicReject(optionalChannel.get().getMessage().getEnvelope().getDeliveryTag(), requeue);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Acknowledged Message for Channel with AckId [" + ackId + "]");
                    }
                    break block4;
                }
                LOGGER.error("The channel could not be acknowledged. This may be due to: \n - The channel has been already acknowledged\n- The channel has been recovered\n - The given 'ackId' :  [" + ackId + "] is invalid.");
                throw new AmqpDeliveryTagNotFoundException("The channel for the manual rejection of the AckId provided was not found");
            }
            catch (Exception e) {
                throw new AmqpAckException("An error occurred during ack", e);
            }
        }
    }
}

