/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.listener;

import com.mule.extensions.amqp.internal.listener.MessageReceiverConsumer;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private static final int MONITOR_INTERVAL = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerManager.class);
    private Map<Integer, ConsumerNode> consumers = new HashMap<Integer, ConsumerNode>();
    private Scheduler scheduler;
    private ScheduledFuture<?> scheduledTask;

    public ConsumerManager(MuleContext muleContext) {
        this.scheduler = muleContext.getSchedulerService().customScheduler(muleContext.getSchedulerBaseConfig().withName(UUID.getUUID() + "-Monitor").withMaxConcurrentTasks(1));
        this.scheduledTask = this.scheduler.scheduleWithFixedDelay((Runnable)new ConsumerRecoveryMonitor(this.consumers), 0L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(Channel channel, String consumerTag, MessageReceiverConsumer messageReceiverConsumer) {
        Map<Integer, ConsumerNode> map = this.consumers;
        synchronized (map) {
            ConsumerNode consumerNode = this.consumers.get(channel.getChannelNumber());
            if (consumerNode == null) {
                consumerNode = new ConsumerNode(messageReceiverConsumer, channel, consumerTag);
                this.consumers.put(channel.getChannelNumber(), consumerNode);
            } else {
                consumerNode.setMessageReceiverConsumer(messageReceiverConsumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConsumers() {
        Map<Integer, ConsumerNode> map = this.consumers;
        synchronized (map) {
            try {
                this.consumers.values().forEach(consumer -> {
                    consumer.release();
                    this.cancelConsumerQuietly((ConsumerNode)consumer);
                    ConsumerManager.closeQuietly(consumer.getChannel());
                    this.stopScheduler();
                });
            }
            finally {
                this.consumers.clear();
            }
        }
    }

    private void cancelConsumerQuietly(ConsumerNode consumer) {
        try {
            consumer.cancelConsumer();
        }
        catch (IOException e) {
            LOGGER.warn("Amqp consumer failed to be cancelled property: ", (Throwable)e);
        }
    }

    private void stopScheduler() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    public static void closeQuietly(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close amqp channel: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendConsumers() {
        Map<Integer, ConsumerNode> map = this.consumers;
        synchronized (map) {
            for (ConsumerNode consumer : this.consumers.values()) {
                try {
                    if (consumer.isCancelled()) continue;
                    consumer.cancelConsumer();
                }
                catch (IOException e) {
                    LOGGER.warn("Error cancelling consumer with tag " + consumer.getConsumerTag());
                }
            }
        }
    }

    public void shutdown() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
        this.releaseConsumers();
    }

    private static class ConsumerRecoveryMonitor
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerRecoveryMonitor.class);
        private Map<Integer, ConsumerNode> consumers;

        public ConsumerRecoveryMonitor(Map<Integer, ConsumerNode> consumers) {
            this.consumers = consumers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<Integer, ConsumerNode> map = this.consumers;
            synchronized (map) {
                for (ConsumerNode consumer : this.consumers.values()) {
                    try {
                        if (!consumer.isCancelled()) continue;
                        consumer.consume();
                        consumer.setCancelled(false);
                    }
                    catch (Exception e) {
                        LOGGER.info("The scheduled recovery couldn't restart the consumer");
                    }
                }
            }
        }
    }

    private class ConsumerNode {
        private MessageReceiverConsumer messageReceiverConsumer;
        private Channel channel;
        private String consumerTag;
        private boolean cancelled;

        public ConsumerNode(MessageReceiverConsumer messageReceiverConsumer, Channel channel, String consumerTag) {
            this.messageReceiverConsumer = messageReceiverConsumer;
            this.channel = channel;
            this.consumerTag = consumerTag;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public String getConsumerTag() {
            return this.consumerTag;
        }

        public void consume() throws IOException {
            this.messageReceiverConsumer.consume(this.channel);
        }

        public void cancelConsumer() throws IOException {
            this.messageReceiverConsumer.cancel(this.channel);
            this.cancelled = true;
        }

        public void setMessageReceiverConsumer(MessageReceiverConsumer messageReceiverConsumer) {
            this.messageReceiverConsumer = messageReceiverConsumer;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConsumerNode other = (ConsumerNode)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.channel == null ? other.channel != null : !this.channel.equals(other.channel));
        }

        private ConsumerManager getOuterType() {
            return ConsumerManager.this;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public void release() {
            this.messageReceiverConsumer.release();
        }
    }
}

