/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpExchangeNotFoundException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpUnroutableMessageException;
import com.mule.extensions.amqp.internal.exception.resolver.ShutdownSignalExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;

public class PublishShutdownSignalExceptionResolver
extends ShutdownSignalExceptionResolver {
    public PublishShutdownSignalExceptionResolver() {
        super(true);
    }

    @Override
    AmqpExtensionException getResourceNotFoundException(String message) {
        return new AmqpExchangeNotFoundException(message);
    }

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        int replyCode;
        if (this.reasonIsChannelClose(throwable) && ((replyCode = this.getReplyCode((ShutdownSignalException)throwable)) == 312 || replyCode == 313)) {
            return new AmqpUnroutableMessageException(throwable.getMessage());
        }
        return super.resolveException(throwable);
    }
}

