/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpConsumeTimeoutException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpQueueNotFoundException;
import com.mule.extensions.amqp.internal.exception.resolver.ShutdownSignalExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;

public class ConsumeShutdownSignalExceptionResolver
extends ShutdownSignalExceptionResolver {
    public static final String TIMEOUT_SIGNAL_MESSAGE = "A timeout was sent by the broker";

    public ConsumeShutdownSignalExceptionResolver() {
        super(true);
    }

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        int replyCode;
        if (this.reasonIsChannelClose(throwable) && (replyCode = this.getReplyCode((ShutdownSignalException)throwable)) == 408) {
            return new AmqpConsumeTimeoutException(TIMEOUT_SIGNAL_MESSAGE);
        }
        return super.resolveException(throwable);
    }

    @Override
    AmqpExtensionException getResourceNotFoundException(String message) {
        return new AmqpQueueNotFoundException(message);
    }
}

