/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.operation;

import com.mule.extensions.amqp.api.exception.AmqpAckErrorTypeProvider;
import com.mule.extensions.amqp.api.exception.AmqpAckException;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import javax.inject.Inject;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmqpAck {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpAck.class);
    @Inject
    private AmqpChannelManager channelManager;

    @Throws(value={AmqpAckErrorTypeProvider.class})
    public void ack(@Summary(value="Deliver Tag of the message to be acknowledged") String ackId) throws AmqpExtensionException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [ack] for message : [" + ackId + "]");
            }
            this.channelManager.ack(ackId);
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while acknowledging  a message with ackId: %s", ackId, e.getMessage());
            throw new AmqpAckException(msg, e);
        }
    }
}

