/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.api.config;

import com.mule.extensions.amqp.api.config.AckMode;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class AmqpConsumerConfig {
    @Parameter
    @Optional(defaultValue="IMMEDIATE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The acknowledgment mode to use when consuming from the AMQP broker.")
    private AckMode ackMode;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="If set to true, the server does not send messages to the connection that published them.")
    private boolean noLocal;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Set to true if the connector should only create exclusive consumers, i.e. only the created consumer can access the queue.")
    private boolean exclusiveConsumers;
    @Parameter
    @Optional(defaultValue="4")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="It is the number of consumers spawned by message source to receive AMQP messages. Each consumer will create a channel.")
    private int numberOfConsumers;

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        this.ackMode = ackMode;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isExclusiveConsumers() {
        return this.exclusiveConsumers;
    }

    public void setExclusiveConsumers(boolean exclusiveConsumers) {
        this.exclusiveConsumers = exclusiveConsumers;
    }

    public int getNumberOfConsumers() {
        return this.numberOfConsumers;
    }

    public void setNumberOfConsumers(int numberOfConsumers) {
        this.numberOfConsumers = numberOfConsumers;
    }

    public int hashCode() {
        return Objects.hash(this.ackMode, this.noLocal, this.exclusiveConsumers, this.numberOfConsumers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AmqpConsumerConfig)) {
            return false;
        }
        AmqpConsumerConfig that = (AmqpConsumerConfig)obj;
        return this.ackMode == that.ackMode && this.noLocal == that.noLocal && this.exclusiveConsumers == that.exclusiveConsumers && this.numberOfConsumers == that.numberOfConsumers;
    }
}

