/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.config;

import com.mule.extensions.amqp.api.config.AmqpConsumerConfig;
import com.mule.extensions.amqp.api.config.AmqpPublisherConfig;
import com.mule.extensions.amqp.api.config.QualityOfService;
import com.mule.extensions.amqp.internal.connection.provider.GenericConnectionProvider;
import com.mule.extensions.amqp.internal.listener.AmqpListener;
import com.mule.extensions.amqp.internal.operation.AmqpAck;
import com.mule.extensions.amqp.internal.operation.AmqpConsume;
import com.mule.extensions.amqp.internal.operation.AmqpPublish;
import com.mule.extensions.amqp.internal.operation.AmqpPublishConsume;
import com.mule.extensions.amqp.internal.operation.AmqpReject;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.Sources;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

@Configuration(name="config")
@Operations(value={AmqpConsume.class, AmqpPublish.class, AmqpPublishConsume.class, AmqpAck.class, AmqpReject.class})
@ConnectionProviders(value={GenericConnectionProvider.class})
@Sources(value={AmqpListener.class})
public class AmqpConfig {
    @DefaultEncoding
    private String muleEncoding;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The default encoding of the Message body to be used if the message doesn't communicate it")
    private String encoding;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional(defaultValue="*/*")
    @Summary(value="The default contentType of the link message body to be used if the message doesn't communicate it")
    private String contentType;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Whether non existing queues will be created according to the fallback definition or an error will be raised if they do not exist.")
    private boolean createFallbackQueue;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Whether non existing exchanges will be created according to the fallback definition or an error will be raised if they do not exist.")
    private boolean createFallbackExchange;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Consumer")
    @ParameterGroup(name="Consumer Config", showInDsl=true)
    @Summary(value="Configuration parameters for consuming messages from a AMQP queue")
    private AmqpConsumerConfig consumerConfig;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Publisher")
    @ParameterGroup(name="Publisher Config", showInDsl=true)
    @Summary(value="Configuration parameters for consuming messages from a AMQP queue")
    private AmqpPublisherConfig publisherConfig;
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Quality of Service")
    @ParameterGroup(name="Quality of Service Config", showInDsl=true)
    @Summary(value="Quality of Service Config")
    private QualityOfService qualityOfService;
    @Parameter
    @Optional(defaultValue="AUTO")
    private OutboundCorrelationStrategy sendCorrelationId = OutboundCorrelationStrategy.AUTO;

    public AmqpConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public void setConsumerConfig(AmqpConsumerConfig consumerConfig) {
        this.consumerConfig = consumerConfig;
    }

    public AmqpPublisherConfig getPublisherConfig() {
        return this.publisherConfig;
    }

    public void setPublisherConfig(AmqpPublisherConfig publisherConfig) {
        this.publisherConfig = publisherConfig;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.encoding == null ? this.muleEncoding : this.encoding;
    }

    public QualityOfService getQualityOfService() {
        return this.qualityOfService;
    }

    public boolean isCreateFallbackQueue() {
        return this.createFallbackQueue;
    }

    public void setDisableCreationOfFallbackQueues(boolean createFallbackQueue) {
        this.createFallbackQueue = createFallbackQueue;
    }

    public boolean isCreateFallbackExchange() {
        return this.createFallbackExchange;
    }

    public void setCreateFallbackExchange(boolean createFallbackExchange) {
        this.createFallbackExchange = createFallbackExchange;
    }
}

