/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.client;

import com.mule.extensions.amqp.internal.client.QueueingConsumer;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SingleMessageQueueingConsumer
extends QueueingConsumer {
    private final AtomicBoolean received;
    private String correlationId;

    public SingleMessageQueueingConsumer(Channel channel, String correlationId) {
        super(channel);
        this.correlationId = correlationId;
        this.received = new AtomicBoolean();
    }

    @Override
    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        if (this.received.get() || this.isInvalidCorrelationId(properties)) {
            this.getChannel().basicReject(envelope.getDeliveryTag(), true);
        } else {
            this.received.set(true);
            super.handleDelivery(consumerTag, envelope, properties, body);
        }
    }

    private boolean isInvalidCorrelationId(AMQP.BasicProperties properties) {
        return this.correlationId != null && !this.correlationId.equals(properties.getCorrelationId());
    }
}

