/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection;

import com.rabbitmq.client.DefaultSocketConfigurator;
import java.io.IOException;
import java.net.Socket;

public class MuleDefaultSocketConfigurator
extends DefaultSocketConfigurator {
    private boolean keepAlive;
    private Long soTimeout;
    private Integer receiveBufferSize;
    private Integer sendBufferSize;

    private MuleDefaultSocketConfigurator(boolean keepAlive, Long soTimeout, Integer receiveBufferSize, Integer sendBufferSize) {
        this.keepAlive = keepAlive;
        this.soTimeout = soTimeout;
        this.receiveBufferSize = receiveBufferSize;
        this.sendBufferSize = sendBufferSize;
    }

    public void configure(Socket socket) throws IOException {
        super.configure(socket);
        socket.setKeepAlive(this.keepAlive);
        if (this.soTimeout != null) {
            socket.setSoTimeout(this.soTimeout.intValue());
        }
        if (this.receiveBufferSize != null) {
            socket.setReceiveBufferSize(this.receiveBufferSize);
        }
        if (this.sendBufferSize != null) {
            socket.setSendBufferSize(this.sendBufferSize);
        }
    }

    public static class Builder {
        private boolean keepAlive;
        private Long soTimeout;
        private Integer receiveBufferSize;
        private Integer sendBufferSize;

        private Builder() {
        }

        public Builder withKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder withSoTimeout(Long soTimeout) {
            this.soTimeout = soTimeout;
            return this;
        }

        public Builder withReceiveBufferSize(Integer receiveBufferSize) {
            this.receiveBufferSize = receiveBufferSize;
            return this;
        }

        public Builder withSendBufferSize(Integer sendBufferSize) {
            this.sendBufferSize = sendBufferSize;
            return this;
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public MuleDefaultSocketConfigurator build() {
            return new MuleDefaultSocketConfigurator(this.keepAlive, this.soTimeout, this.receiveBufferSize, this.sendBufferSize);
        }
    }
}

