/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.publisher;

import com.mule.extensions.amqp.internal.publisher.ConfirmHandler;
import com.mule.extensions.amqp.internal.publisher.ConfirmsManager;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConfirmListener;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class DefaultConfirmsManager
implements ConfirmsManager {
    private boolean requestBrokerConfirms;
    private final Map<Long, ConfirmHandler> pendingConfirms = new ConcurrentHashMap<Long, ConfirmHandler>();

    public DefaultConfirmsManager(boolean requestBrokerConfirms) {
        this.requestBrokerConfirms = requestBrokerConfirms;
    }

    @Override
    public long requestConfirm(Channel channel) throws Exception {
        if (!this.handlesConfirms()) {
            return -1L;
        }
        channel.addConfirmListener(new ConfirmListener(){

            public void handleAck(long deliveryTag, boolean multiple) throws IOException {
                DefaultConfirmsManager.this.confirm(deliveryTag, true);
            }

            public void handleNack(long deliveryTag, boolean multiple) throws IOException {
                DefaultConfirmsManager.this.confirm(deliveryTag, false);
            }
        });
        channel.confirmSelect();
        long nextSequence = channel.getNextPublishSeqNo();
        this.pendingConfirms.put(nextSequence, new ConfirmHandler());
        return nextSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitConfirm(Channel channel, Long seqNo, long timeout, TimeUnit timeUnit) {
        try {
            if (!this.handlesConfirms()) {
                boolean bl = true;
                return bl;
            }
            if (seqNo == null) {
                throw new IllegalStateException("Event is missing publish sequence number");
            }
            ConfirmHandler confirmHandler = this.pendingConfirms.get(seqNo);
            if (confirmHandler != null) {
                boolean bl = confirmHandler.awaitConfirmation(timeout, timeUnit);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            channel.clearConfirmListeners();
        }
    }

    @Override
    public void forget(Long seqNo) {
        if (seqNo != -1L) {
            this.pendingConfirms.remove(seqNo);
        }
    }

    private void confirm(long deliveryTag, boolean success) {
        ConfirmHandler handler = this.pendingConfirms.get(deliveryTag);
        if (handler != null) {
            handler.confirm(success);
        }
    }

    private boolean handlesConfirms() {
        return this.requestBrokerConfirms;
    }
}

