/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.api.message;

import com.mule.extensions.amqp.api.config.DeliveryMode;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.message.AmqpProperties;
import com.mule.extensions.amqp.internal.message.AmqpMessageUtils;
import com.mule.extensions.amqp.internal.model.message.Message;
import java.util.Map;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;

public class AmqpMessageBuilder {
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Content(primary=true)
    @Summary(value="The body of the Message")
    private TypedValue<Object> body;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="AMQP Properties")
    @Summary(value="The AMQP properties that should be set to this Message")
    private AmqpProperties properties;
    @Content
    @Parameter
    @Optional
    @NullSafe
    @Summary(value="The custom headers that may be set to this Message")
    private Map<String, Object> headers;

    public TypedValue<Object> getBody() {
        return this.body;
    }

    public void setBody(TypedValue<Object> body) {
        this.body = body;
    }

    public AmqpProperties getProperties() {
        return this.properties;
    }

    public void setProperties(AmqpProperties properties) {
        this.properties = properties;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public Message build(boolean mandatory, boolean immediate, String routingKey, String exchange, String configContentType, String configEncoding, DeliveryMode deliveryMode, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo, TransformationService transformationService) throws AmqpExtensionException {
        return AmqpMessageUtils.toMessage(this.body, this.properties, this.headers, mandatory, immediate, routingKey, exchange, configContentType, configEncoding, deliveryMode, outboundCorrelationStrategy, correlationInfo, transformationService);
    }

    public String getReplyToQueue() {
        return this.properties.getReplyTo();
    }

    public void setReplyTo(String replyTo) {
        this.properties.setReplyTo(replyTo);
    }

    public void overridePriorityIfNeeded(Integer priority) {
        if (this.properties.getPriority() == null) {
            this.properties.setPriority(priority);
        }
    }
}

