/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.api.message;

import com.mule.extensions.amqp.api.message.Envelope;
import com.mule.extensions.amqp.api.model.Properties;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class AmqpAttributes
implements Serializable {
    private static final long serialVersionUID = -2925583556993270498L;
    @Parameter
    private Envelope envelope;
    @Parameter
    private Properties properties;
    @Parameter
    private Map<String, Object> headers;
    @Parameter
    @Optional
    private String ackId;

    private AmqpAttributes(Envelope envelope, Properties properties, String ackId, Map<String, Object> headers) {
        this.envelope = envelope;
        this.properties = properties;
        this.ackId = ackId;
        this.headers = headers;
    }

    public AmqpAttributes() {
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getAckId() {
        return this.ackId;
    }

    public void setAckId(String ackId) {
        this.ackId = ackId;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public static class Builder {
        private Properties properties;
        private Envelope envelope;
        private String ackId;
        private Map<String, Object> headers;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Builder withEnvelope(Envelope envelope) {
            this.envelope = envelope;
            return this;
        }

        public Builder withAckId(String ackId) {
            this.ackId = ackId;
            return this;
        }

        public Builder withHeaders(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public AmqpAttributes build() {
            Preconditions.checkArgument((this.properties != null ? 1 : 0) != 0, (String)"No Properties were provided, but they are required for the AmqpAttributes");
            Preconditions.checkArgument((this.envelope != null ? 1 : 0) != 0, (String)"No Envelope were provided, but they are required for the AmqpAttributes");
            if (this.headers == null) {
                this.headers = new HashMap<String, Object>();
            }
            return new AmqpAttributes(this.envelope, this.properties, this.ackId, this.headers);
        }
    }
}

