/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.exception.resolver;

import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.internal.exception.resolver.ExceptionResolver;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;
import org.mule.runtime.api.connection.ConnectionException;

public abstract class ShutdownSignalExceptionResolver
implements ExceptionResolver {
    public static final String CHANNEL_CLOSE = "channel.close";
    private boolean connectionExceptionByDefault;

    public ShutdownSignalExceptionResolver(boolean connectionExceptionByDefault) {
        this.connectionExceptionByDefault = connectionExceptionByDefault;
    }

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        int replyCode;
        if (this.reasonIsChannelClose(throwable) && (replyCode = this.getReplyCode((ShutdownSignalException)throwable)) == 404) {
            return this.getResourceNotFoundException(throwable.getMessage());
        }
        if (this.connectionExceptionByDefault) {
            return new AmqpExtensionException("Connectivity Error", (Exception)new ConnectionException(throwable, null));
        }
        return new AmqpExtensionException(throwable.getMessage());
    }

    abstract AmqpExtensionException getResourceNotFoundException(String var1);

    protected boolean reasonIsChannelClose(Throwable throwable) {
        return this.isExceptionOf(throwable, CHANNEL_CLOSE);
    }

    private boolean isExceptionOf(Throwable throwable, String reason) {
        if (throwable instanceof ShutdownSignalException) {
            ShutdownSignalException exception = (ShutdownSignalException)throwable;
            return exception.getReason() != null && exception.getReason().protocolMethodName().equals(CHANNEL_CLOSE);
        }
        return false;
    }

    protected int getReplyCode(ShutdownSignalException exception) {
        return ((AMQImpl.Channel.Close)exception.getReason()).getReplyCode();
    }

    public boolean isConnectionExceptionByDefault() {
        return this.connectionExceptionByDefault;
    }
}

