/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.message;

import com.mule.extensions.amqp.api.config.DeliveryMode;
import com.mule.extensions.amqp.api.model.Properties;
import com.rabbitmq.client.Envelope;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class AmqpMessage {
    private final String consumerTag;
    private final Envelope envelope;
    private final byte[] body;
    private Map<String, Object> headers;
    private Properties properties;

    public AmqpMessage(String consumerTag, Envelope envelope, Properties properties, Map<String, Object> headers, byte[] body) {
        this.consumerTag = consumerTag;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
        this.headers = headers;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setDeliveryMode(DeliveryMode deliveryMode) {
        this.properties.setDeliveryMode(deliveryMode);
    }

    public void setPriority(int priority) {
        this.properties.setPriority(priority);
    }

    public String getReplyTo() {
        return this.properties.getReplyTo();
    }

    public void setReplyTo(String replyTo) {
        this.properties.setReplyTo(replyTo);
    }

    public byte[] getBody() {
        return this.body;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

