/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection.provider;

import com.mule.extensions.amqp.api.config.AmqpAddress;
import com.mule.extensions.amqp.api.config.SocketConfiguration;
import com.mule.extensions.amqp.internal.connection.AmqpConnection;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.MuleDefaultSocketConfigurator;
import com.mule.extensions.amqp.internal.connection.param.GenericConnectionParameters;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SocketConfigurator;
import com.rabbitmq.client.SslContextFactory;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.net.SocketFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="connection")
public class GenericConnectionProvider
implements CachedConnectionProvider<AmqpTransactionalConnection>,
Initialisable,
Disposable {
    private static final String TLS_CONFIGURATION = "TLS Configuration";
    private static final String SOCKET_CONFIGURATION = "Socket Configuration";
    private static final Integer PLAIN_CONNECTION_PORT = 5672;
    private static final Integer SECURE_CONNECTION_PORT = 5671;
    private TlsContextFactoryBuilder defaultTlsContextFactoryBuilder = TlsContextFactory.builder();
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericConnectionProvider.class);
    @ParameterGroup(name="Connection")
    private GenericConnectionParameters connectionParameters;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="TLS Configuration")
    @Placement(tab="TLS")
    private TlsContextFactory tlsContext;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Socket Configuration")
    @Placement(tab="Socket Configuration")
    @ExcludeFromConnectivitySchema
    private SocketConfiguration socketConfiguration;
    private ConnectionFactory connectionFactory;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;

    public AmqpTransactionalConnection connect() throws ConnectionException {
        ArrayList<Address> brokerAddresses = new ArrayList<Address>();
        brokerAddresses.add(new Address(this.connectionParameters.getHost(), this.getConnectionFactoryPort().intValue()));
        this.addFallbackAddresses(brokerAddresses);
        ConnectionException lastException = null;
        AmqpTransactionalConnection transactionalConnection = null;
        for (Address address : brokerAddresses) {
            lastException = null;
            try {
                this.connectionFactory.setHost(address.getHost());
                this.connectionFactory.setPort(address.getPort());
                this.connectionFactory.setRequestedHeartbeat(this.connectionParameters.getHeartbeatTimeout());
                if (this.connectionParameters.isUseSasl()) {
                    this.connectionFactory.setSaslConfig((SaslConfig)DefaultSaslConfig.EXTERNAL);
                } else {
                    this.connectionFactory.setUsername(this.connectionParameters.getUsername());
                    this.connectionFactory.setPassword(this.connectionParameters.getPassword());
                }
                if (this.connectionParameters.getHandshakeTimeout() != null) {
                    this.connectionFactory.setHandshakeTimeout(new Long(this.connectionParameters.getHandshakeTimeoutTimeUnit().toMillis(this.connectionParameters.getHandshakeTimeout().intValue())).intValue());
                }
                if (this.socketConfiguration != null) {
                    MuleDefaultSocketConfigurator.Builder builder = MuleDefaultSocketConfigurator.Builder.newInstance().withKeepAlive(this.socketConfiguration.isKeepAlive()).withReceiveBufferSize(this.socketConfiguration.getReceiveBufferSize()).withSendBufferSize(this.socketConfiguration.getSendBufferSize());
                    if (this.socketConfiguration.getSoTimeout() != null) {
                        builder.withSoTimeout(this.socketConfiguration.getSoTimeoutTimeUnit().toMillis(this.socketConfiguration.getSoTimeout().intValue()));
                    }
                    MuleDefaultSocketConfigurator socketConfigurator = builder.build();
                    this.connectionFactory.setSocketConfigurator((SocketConfigurator)socketConfigurator);
                }
                Connection connection = this.connectionFactory.newConnection((ExecutorService)this.scheduler);
                transactionalConnection = new AmqpTransactionalConnection(connection);
            }
            catch (Exception e) {
                lastException = new ConnectionException(e.getMessage(), e.getCause());
            }
            if (lastException != null) continue;
            break;
        }
        if (lastException != null) {
            throw lastException;
        }
        return transactionalConnection;
    }

    public void disconnect(AmqpTransactionalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Disconnection Started");
        }
        this.doStop(connection);
        this.doClose(connection);
    }

    public ConnectionValidationResult validate(AmqpTransactionalConnection connection) {
        try {
            Channel channel = connection.createChannel();
            channel.close();
        }
        catch (Exception e) {
            ConnectionValidationResult.failure((String)"Error validating AMQP connection", (Exception)e);
        }
        return ConnectionValidationResult.success();
    }

    public void dispose() {
        this.connectionFactory = null;
        this.shutdownScheduler();
    }

    private void shutdownScheduler() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    public void initialise() throws InitialisationException {
        if (!this.connectionParameters.isUseTls() && this.tlsContext != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"TlsContext cannot be configured without setting useTls. If you defined a tls:context element in your connection configuration then you must set useTls"), (Initialisable)this);
        }
        if (this.connectionParameters.isUseTls() && this.tlsContext == null) {
            this.tlsContext = this.defaultTlsContextFactoryBuilder.buildDefault();
        }
        if (this.connectionParameters.isUseSni() && !this.connectionParameters.isUseTls()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"SNI can only be set using a TLS Context"), (Initialisable)this);
        }
        if (this.connectionParameters.isUseSasl() && !this.connectionParameters.isUseTls()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Use SASL can only be set using a TLS Context"), (Initialisable)this);
        }
        if (!this.connectionParameters.isUseSasl() && this.connectionParameters.getUsername().isEmpty()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Username is required when no using Sasl"), (Initialisable)this);
        }
        if (!this.connectionParameters.isUseSasl() && this.connectionParameters.getPassword().isEmpty()) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Password is required when no using Sasl"), (Initialisable)this);
        }
        if (this.tlsContext != null) {
            LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
        }
        this.scheduler = this.schedulerService.ioScheduler();
        this.initialiseConnectionFactory();
        if (this.tlsContext != null) {
            try {
                this.setSocketFactory();
                this.setSslContext();
            }
            catch (Exception e) {
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Error while creating socket factory."), (Initialisable)this);
            }
        }
    }

    private void setSslContext() throws KeyManagementException, NoSuchAlgorithmException {
        final SSLContext sslContext = this.tlsContext.createSslContext();
        this.connectionFactory.setSslContextFactory(new SslContextFactory(){

            public SSLContext create(String name) {
                return sslContext;
            }
        });
    }

    private void addFallbackAddresses(List<Address> brokerAddresses) {
        List<AmqpAddress> fallbackAddresses = this.connectionParameters.getFallbackAddresses();
        if (fallbackAddresses == null) {
            return;
        }
        for (AmqpAddress fallbackAddress : fallbackAddresses) {
            if (fallbackAddress.getPort() != null) {
                brokerAddresses.add(new Address(fallbackAddress.getHost(), Integer.parseInt(fallbackAddress.getPort())));
                continue;
            }
            brokerAddresses.add(new Address(fallbackAddress.getHost(), this.getConnectionFactoryPort().intValue()));
        }
    }

    private void setSocketFactory() throws Exception {
        this.connectionFactory.setSocketFactory((SocketFactory)this.tlsContext.createSocketFactory());
    }

    private void initialiseConnectionFactory() {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setVirtualHost(this.connectionParameters.getVirtualHost());
        this.connectionFactory.setAutomaticRecoveryEnabled(true);
        if (this.connectionParameters.isUseSni()) {
            this.setupSni();
        }
    }

    private void setupSni() {
        this.connectionFactory.setSocketConfigurator(new SocketConfigurator(){

            public void configure(Socket socket) throws IOException {
                if (socket instanceof SSLSocket) {
                    GenericConnectionProvider.this.configureSniParameters(((SSLSocket)socket).getSSLParameters());
                }
            }
        });
    }

    private void configureSniParameters(SSLParameters sslParameters) {
        ArrayList<SNIServerName> servers = new ArrayList<SNIServerName>();
        servers.add(new SNIHostName(this.connectionFactory.getHost()));
        sslParameters.setServerNames(servers);
    }

    private Integer getConnectionFactoryPort() {
        if (this.connectionParameters.getPort() != null) {
            return this.connectionParameters.getPort();
        }
        if (this.connectionParameters.isUseTls()) {
            return SECURE_CONNECTION_PORT;
        }
        return PLAIN_CONNECTION_PORT;
    }

    protected void doStop(AmqpConnection amqpConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doStop: [%s]", this.getClass().getName()));
        }
        try {
            LifecycleUtils.stopIfNeeded((Object)amqpConnection);
        }
        catch (Exception e) {
            LOGGER.warn("Jms connection failed to stop properly: ", (Throwable)e);
        }
    }

    protected void doClose(AmqpConnection jmsConnection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Perform doClose: [%s]", this.getClass().getName()));
        }
        LifecycleUtils.disposeIfNeeded((Object)jmsConnection, (Logger)LOGGER);
    }
}

