/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.listener;

import com.mule.extensions.amqp.internal.common.AmqpCommons;
import com.mule.extensions.amqp.internal.connection.channel.MuleAmqpChannel;
import com.mule.extensions.amqp.internal.listener.MessageReceiverConsumer;
import com.mule.extensions.amqp.internal.listener.MultiChannelReceiverManager;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Objects;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiChannelMessageSubReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiChannelMessageSubReceiver.class);
    private MultiChannelReceiverManager multiChannelReceiverManager;
    private String consumerTag;
    private Channel channel;
    private boolean released;

    public MultiChannelMessageSubReceiver(MultiChannelReceiverManager multiChannelReceiverManager) {
        this.multiChannelReceiverManager = multiChannelReceiverManager;
    }

    public void start() throws IOException {
        this.resolveChannel();
        this.consume(this.channel);
        LOGGER.info("Started subscription: " + this.consumerTag + " on channel: " + this.channel);
    }

    public void consume(Channel channel) throws IOException {
        MessageReceiverConsumer messageReceiverConsumer = new MessageReceiverConsumer(channel, this.multiChannelReceiverManager.getSourceCallback(), this.multiChannelReceiverManager.getInboundEncoding(), this.multiChannelReceiverManager.getConfigEncoding(), this.multiChannelReceiverManager.getInboundContentType(), this.multiChannelReceiverManager.getConfigContentType(), this.multiChannelReceiverManager.getAckMode(), this.multiChannelReceiverManager.getChannelManager(), this.multiChannelReceiverManager.getConnection(), this);
        this.consumerTag = channel.basicConsume(this.multiChannelReceiverManager.getQueueName(), this.multiChannelReceiverManager.getAckMode().isImmediateAck(), this.multiChannelReceiverManager.getConsumerTag(), this.multiChannelReceiverManager.isNoLocal(), this.multiChannelReceiverManager.isExclusiveConsumers(), null, (Consumer)messageReceiverConsumer);
        this.multiChannelReceiverManager.getConsumerManager().addConsumer(channel, this.consumerTag, messageReceiverConsumer);
    }

    private void resolveChannel() throws IOException {
        MuleAmqpChannel muleChannel;
        if (this.multiChannelReceiverManager.getTransactionalAction().equals((Object)SourceTransactionalAction.ALWAYS_BEGIN)) {
            this.channel = new MuleAmqpChannel(AmqpCommons.getOrCreateTransactedChannel(this.multiChannelReceiverManager.getConnection(), this.multiChannelReceiverManager.getChannelManager(), this.multiChannelReceiverManager.getChannelManager().getTransactedChannel(), false), true);
        } else {
            this.channel = new MuleAmqpChannel(this.multiChannelReceiverManager.getConnection().createChannel(), false);
            this.channel.basicQos(this.multiChannelReceiverManager.getQualityOfService().getPrefetchSize(), this.multiChannelReceiverManager.getQualityOfService().getPrefetchCount(), false);
        }
        if (this.channel instanceof MuleAmqpChannel && !(muleChannel = (MuleAmqpChannel)this.channel).isInTransaction()) {
            this.channel.addShutdownListener(new ShutdownListener(){

                public void shutdownCompleted(ShutdownSignalException cause) {
                    try {
                        if (Objects.nonNull(MultiChannelMessageSubReceiver.this.channel) && MultiChannelMessageSubReceiver.this.channel.isOpen()) {
                            MultiChannelMessageSubReceiver.this.channel.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error closing channel " + MultiChannelMessageSubReceiver.this.channel.getConnection().getId() + "/" + MultiChannelMessageSubReceiver.this.channel.getChannelNumber() + ": " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    public void cancel(Channel channel) {
        try {
            if (channel.isOpen()) {
                channel.basicCancel(this.consumerTag);
            } else {
                this.multiChannelReceiverManager.getSourceCallback().onConnectionException(new ConnectionException("Channel Closed"));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Exception cancelling a consumer " + this.consumerTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(boolean cancelSubscription) {
        MultiChannelMessageSubReceiver multiChannelMessageSubReceiver = this;
        synchronized (multiChannelMessageSubReceiver) {
            if (!cancelSubscription && !this.released) {
                this.consumerTag = null;
                try {
                    this.stop();
                    this.start();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to restart receiver: " + this, (Throwable)e);
                    this.multiChannelReceiverManager.getSourceCallback().onConnectionException(new ConnectionException((Throwable)e, (Object)this.multiChannelReceiverManager.getConnection()));
                }
            }
        }
    }

    private void stop() {
        LOGGER.debug("Stopping subreceiver " + this.multiChannelReceiverManager.getQueueName() + " on channel: " + this.channel.getChannelNumber());
        try {
            if (this.channel == null) {
                return;
            }
            if (this.consumerTag != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Cancelling subscription of: " + this.consumerTag + " on channel: " + this.channel);
                }
                this.channel.basicCancel(this.consumerTag);
                LOGGER.info("Cancelled subscription of: " + this.consumerTag + " on channel: " + this.channel);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Disconnecting receiver for queue: " + this.multiChannelReceiverManager.getQueueName() + " from channel: " + this.channel.getChannelNumber());
            }
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to cancel subscription: " + this.consumerTag + " on channel: " + this.channel, (Throwable)e);
        }
        finally {
            LOGGER.debug("Stopped subreceiver " + this.multiChannelReceiverManager.getQueueName() + " on channel: " + this.channel.getChannelNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        MultiChannelMessageSubReceiver multiChannelMessageSubReceiver = this;
        synchronized (multiChannelMessageSubReceiver) {
            this.released = true;
        }
    }
}

