/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.publisher;

import com.mule.extensions.amqp.api.exception.AmqpBlockedBrokerException;
import com.mule.extensions.amqp.internal.common.AmqpCommons;
import com.mule.extensions.amqp.internal.config.AmqpConfig;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.publish.AmqpPublishParameters;

public class AmqpPublisherCommons {
    public static void checkBrokerNotBlocked(AmqpTransactionalConnection connection) {
        if (connection.isBlockedByBroker()) {
            String msg = String.format("The broker is currently blocked due to being low in resources. A notification was handled.", new Object[0]);
            throw new AmqpBlockedBrokerException(msg);
        }
    }

    public static String resolvedReturnedMessageExchange(AmqpConfig config, AmqpPublishParameters overrides) {
        return AmqpCommons.resolveOverride(config.getPublisherConfig().getReturnedMessageExchange(), AmqpCommons.resolveReturnedMessageExchange(config.getPublisherConfig().getReturnedMessageExchange(), overrides.getReturnedMessageExchange()));
    }

    public static boolean resolveRequestBrokerConfirms(AmqpConfig config, AmqpPublishParameters overrides) {
        return AmqpCommons.resolveOverride(config.getPublisherConfig().isRequestBrokerConfirms(), overrides.isRequestBrokerConfirms());
    }
}

