/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.publisher;

import com.mule.extensions.amqp.api.exception.AmqpPublishException;
import com.mule.extensions.amqp.internal.model.message.Message;
import com.mule.extensions.amqp.internal.publisher.AmqpMessagePublisher;
import com.mule.extensions.amqp.internal.publisher.DefaultConfirmsManager;
import com.mule.extensions.amqp.internal.publisher.DispatcherReturnHandlerListener;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAmqpMessagePublisher
implements AmqpMessagePublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAmqpMessagePublisher.class);
    private String exchangeName;
    private Channel channel;
    private String returnedMessageExchange;
    private DefaultConfirmsManager confirmsManager;

    private DefaultAmqpMessagePublisher(Channel channel, String exchangeName, String returnedMessageExchange, boolean requestBrokerConfirms, Connection connection) {
        this.channel = channel;
        this.exchangeName = exchangeName;
        this.returnedMessageExchange = returnedMessageExchange;
        this.confirmsManager = new DefaultConfirmsManager(requestBrokerConfirms);
    }

    @Override
    public void publish(Message message) throws AmqpPublishException {
        long seqNo = -1L;
        try {
            this.channel.clearReturnListeners();
            this.channel.clearConfirmListeners();
            if (this.returnedMessageExchange != null) {
                this.channel.addReturnListener((ReturnListener)new DispatcherReturnHandlerListener(this.returnedMessageExchange, this.channel));
            }
            try {
                seqNo = this.confirmsManager.requestConfirm(this.channel);
            }
            catch (Exception e) {
                throw new AmqpPublishException("Broker failed to agree on confirming messages", e);
            }
            this.channel.basicPublish(this.exchangeName, message.getRoutingKey(), message.isImmediate(), message.isMandatory(), message.getProperties(), message.getBody());
            if (!this.confirmsManager.awaitConfirm(this.channel, seqNo, 10000L, TimeUnit.MILLISECONDS)) {
                throw new AmqpPublishException("Broker failed to acknowledge delivery of message");
            }
        }
        catch (IOException e) {
            throw new AmqpPublishException(e.getMessage(), e);
        }
        finally {
            this.confirmsManager.forget(seqNo);
        }
    }

    public static class Builder {
        private String exchangeName;
        private Channel channel;
        private String returnedMessageExchange;
        private boolean requestBrokerConfirms;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withExchangeName(String exchangeName) {
            this.exchangeName = exchangeName;
            return this;
        }

        public Builder withChannel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public Builder withReturnedMessageExchange(String returnedMessageExchange) {
            this.returnedMessageExchange = returnedMessageExchange;
            return this;
        }

        public Builder withRequestBrokerConfirms(boolean requestBrokerConfirms) {
            this.requestBrokerConfirms = requestBrokerConfirms;
            return this;
        }

        public DefaultAmqpMessagePublisher build() {
            return new DefaultAmqpMessagePublisher(this.channel, this.exchangeName, this.returnedMessageExchange, this.requestBrokerConfirms, null);
        }
    }
}

