/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.utils;

import com.mule.extensions.amqp.internal.operation.AmqpAck;
import com.rabbitmq.client.LongString;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectToMapTransformer {
    private static final Set<Class<?>> EXCLUDED_JAVA_CLASSES = new HashSet();
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpAck.class);

    public static Map<String, Object> transform(Object obj) {
        return ObjectToMapTransformer.transform(obj, new HashSet<Object>());
    }

    private static Map<String, Object> transform(Object obj, Set<Object> visited) {
        if (obj == null) {
            return null;
        }
        if (visited.contains(obj)) {
            return null;
        }
        visited.add(obj);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Class<?> clazz = obj.getClass(); clazz != null && !EXCLUDED_JAVA_CLASSES.contains(clazz); clazz = clazz.getSuperclass()) {
            Object[] fields = clazz.getDeclaredFields();
            List workableFields = Arrays.stream(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> Modifier.isPublic(field.getModifiers()) || field.isAccessible()).collect(Collectors.toList());
            for (Field field2 : workableFields) {
                try {
                    Object value = field2.get(obj);
                    if (value == null) continue;
                    resultMap.put(field2.getName(), ObjectToMapTransformer.transformValue(value, visited));
                }
                catch (IllegalAccessException value) {}
            }
        }
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(obj.getClass()).getPropertyDescriptors()) {
                Object value;
                Method getter = pd.getReadMethod();
                if (getter == null || !ObjectToMapTransformer.isGetter(getter) || (value = getter.invoke(obj, new Object[0])) == null) continue;
                resultMap.put(pd.getName(), ObjectToMapTransformer.transformValue(value, visited));
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error invoking getters on object: " + obj.getClass() + "\n", (Throwable)e);
        }
        return resultMap;
    }

    public static Object transformValue(Object value) {
        return ObjectToMapTransformer.transformValue(value, new HashSet<Object>());
    }

    public static Object transformValue(Object value, Set<Object> visited) {
        if (value == null) {
            return null;
        }
        if (value.getClass().isPrimitive() || value instanceof String || value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return value;
        }
        if (value instanceof LongString) {
            HashMap<String, Object> lsMap = new HashMap<String, Object>();
            lsMap.put("stream", ((LongString)value).toString());
            lsMap.put("bytes", ((LongString)value).getBytes());
            return lsMap;
        }
        if (value instanceof List) {
            return ((List)value).stream().map(item -> ObjectToMapTransformer.transformValue(item, visited)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            return ((Map)value).entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> ObjectToMapTransformer.transformValue(entry.getValue(), visited)));
        }
        return ObjectToMapTransformer.transform(value, visited);
    }

    private static boolean isGetter(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("get") && !methodName.startsWith("is") || methodName.equals("getClass")) {
            return false;
        }
        if (method.getParameterCount() != 0) {
            return false;
        }
        if (Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        return !methodName.startsWith("is") || Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType());
    }
}

