/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal;

import com.mule.extensions.amqp.api.exception.AmqpError;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.internal.exception.resolver.ExceptionResolver;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.extension.api.error.MuleErrors;

public abstract class AbstractExceptionResolver
implements ExceptionResolver {
    private AmqpError generalErrorType;
    private Map<String, ExceptionResolver> resolvers = new HashMap<String, ExceptionResolver>();

    public AbstractExceptionResolver(AmqpError generalErrorType) {
        this.generalErrorType = generalErrorType;
        this.registerResolvers();
    }

    public abstract void registerResolvers();

    @Override
    public AmqpExtensionException resolveException(Throwable throwable) {
        String canonicalName = throwable.getClass().getCanonicalName();
        if (this.resolvers.containsKey(canonicalName)) {
            return this.resolvers.get(canonicalName).resolveException(throwable);
        }
        if (this.mustReturnSameException(throwable)) {
            return (AmqpExtensionException)((Object)throwable);
        }
        return new AmqpExtensionException(throwable.getMessage(), this.generalErrorType);
    }

    private boolean mustReturnSameException(Throwable throwable) {
        return throwable instanceof AmqpExtensionException && !((AmqpExtensionException)((Object)throwable)).getType().equals(MuleErrors.ANY);
    }

    protected void registerResolver(String canonicalName, ExceptionResolver exceptionResolver) {
        this.resolvers.put(canonicalName, exceptionResolver);
    }
}

