/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection.channel;

import com.mule.extensions.amqp.api.config.QualityOfService;
import com.mule.extensions.amqp.api.exception.AmqpAckException;
import com.mule.extensions.amqp.api.exception.AmqpDeliveryTagNotFoundException;
import com.mule.extensions.amqp.internal.common.AmqpCommons;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.channel.ChannelInformation;
import com.mule.extensions.amqp.internal.connection.channel.MuleAmqpChannel;
import com.mule.extensions.amqp.internal.connection.channel.TransactionInformation;
import com.mule.extensions.amqp.internal.connection.channel.TransactionStatus;
import com.mule.extensions.amqp.internal.message.AmqpMessage;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpChannelManager.class);
    private final Map<String, ChannelInformation> pendingChannels = new HashMap<String, ChannelInformation>();
    private final Map<Integer, Integer> acksCountPendingChannels = new HashMap<Integer, Integer>();
    private final ThreadLocal<TransactionInformation> transactionInformation = new ThreadLocal();

    public void bindToTransaction(Channel channel) {
        this.getTransactionInformation().setChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMessageForAck(String ackId, AmqpMessage message, Channel channel) {
        Map<String, ChannelInformation> map = this.pendingChannels;
        synchronized (map) {
            if (!this.pendingChannels.containsKey(ackId)) {
                this.pendingChannels.put(ackId, new ChannelInformation(message, channel));
            }
            Map<Integer, Integer> map2 = this.acksCountPendingChannels;
            synchronized (map2) {
                Integer countPendingAcks = this.acksCountPendingChannels.get(channel.getChannelNumber());
                this.acksCountPendingChannels.put(channel.getChannelNumber(), countPendingAcks == null ? 1 : countPendingAcks + 1);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered Message for Channel AckId [{}]", (Object)ackId);
        }
    }

    public void ack(String ackId) throws AmqpAckException {
        block4: {
            Optional<ChannelInformation> optionalChannel = this.getChannelInformation(ackId);
            try {
                if (optionalChannel.isPresent()) {
                    MuleAmqpChannel channel = (MuleAmqpChannel)optionalChannel.get().getChannel();
                    channel.basicAck(optionalChannel.get().getMessage().getEnvelope().getDeliveryTag(), false);
                    this.accountPendingAcks(channel);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Acknowledged Message for Channel with AckId [{}]", (Object)ackId);
                    }
                    break block4;
                }
                LOGGER.error("The channel could not be acknowledged. This may be due to: \n - The channel has been already acknowledged\n- The channel has been recovered\n - The given 'ackId' :  [{}] is invalid.", (Object)ackId);
                throw new AmqpDeliveryTagNotFoundException("The channel for the manual acknowledge of the AckId provided was not found");
            }
            catch (Exception e) {
                throw new AmqpAckException("An error occurred during ack", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ChannelInformation> getChannelInformation(String ackId) {
        Map<String, ChannelInformation> map = this.pendingChannels;
        synchronized (map) {
            return Optional.ofNullable(this.pendingChannels.remove(ackId));
        }
    }

    public TransactionInformation getTransactionInformation() {
        TransactionInformation transactionInfo = this.transactionInformation.get();
        if (transactionInfo == null) {
            transactionInfo = new TransactionInformation();
            this.transactionInformation.set(transactionInfo);
        }
        return transactionInfo;
    }

    public void unbindChannel() {
        this.transactionInformation.remove();
    }

    public Optional<Channel> getTransactedChannel() {
        return Optional.ofNullable(this.getTransactionInformation().getChannel());
    }

    public TransactionStatus getTransactionStatus() {
        TransactionStatus transactionStatus = this.getTransactionInformation().getTransactionStatus();
        return transactionStatus != null ? transactionStatus : TransactionStatus.NONE;
    }

    public void changeTransactionStatus(TransactionStatus transactionStatus) {
        this.getTransactionInformation().setTransactionStatus(transactionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accountPendingAcks(MuleAmqpChannel channel) {
        Map<Integer, Integer> map = this.acksCountPendingChannels;
        synchronized (map) {
            Integer countPendingAcks = this.acksCountPendingChannels.get(channel.getChannelNumber());
            if (countPendingAcks == 1) {
                this.acksCountPendingChannels.remove(channel.getChannelNumber());
                if (channel.isSingleMessageChannel()) {
                    AmqpCommons.releaseChannelIfNeeded(channel);
                }
            }
        }
    }

    public void reject(String ackId, boolean requeue) {
        block4: {
            Optional<ChannelInformation> optionalChannel = this.getChannelInformation(ackId);
            try {
                if (optionalChannel.isPresent()) {
                    MuleAmqpChannel channel = (MuleAmqpChannel)optionalChannel.get().getChannel();
                    channel.basicReject(optionalChannel.get().getMessage().getEnvelope().getDeliveryTag(), requeue);
                    this.accountPendingAcks(channel);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Rejected Message for Channel with AckId [{}]", (Object)ackId);
                    }
                    break block4;
                }
                LOGGER.error("The channel could not be acknowledged. This may be due to: \n - The channel has been already acknowledged\n- The channel has been recovered\n - The given 'ackId' :  [{}] is invalid.", (Object)ackId);
                throw new AmqpDeliveryTagNotFoundException("The channel for the manual rejection of the AckId provided was not found");
            }
            catch (Exception e) {
                throw new AmqpAckException("An error occurred during Reject", e);
            }
        }
    }

    public MuleAmqpChannel createAmqpChannel(AmqpTransactionalConnection connection, OperationTransactionalAction transactionalAction, boolean singleMessageChannel) throws IOException {
        return this.createAmqpChannelWithTransactionValidation(connection, transactionalAction, null, singleMessageChannel);
    }

    public MuleAmqpChannel createAmqpChannelWithTransactionValidation(AmqpTransactionalConnection connection, OperationTransactionalAction transactionalAction, QualityOfService qualityOfService, boolean singleMessageChannel) throws IOException {
        return !transactionalAction.equals((Object)OperationTransactionalAction.NOT_SUPPORTED) ? new MuleAmqpChannel(this.getOrCreateTransactedChannel(connection, this.getTransactedChannel()), !this.getTransactionStatus().equals((Object)TransactionStatus.NONE), singleMessageChannel) : this.createNewChannel(connection, qualityOfService, singleMessageChannel);
    }

    public MuleAmqpChannel createNewChannel(AmqpTransactionalConnection connection, QualityOfService qualityOfService, boolean singleMessageChannel) throws IOException {
        Channel channel = connection.createChannel();
        if (qualityOfService != null) {
            channel.basicQos(qualityOfService.getPrefetchSize(), qualityOfService.getPrefetchCount(), false);
        }
        return new MuleAmqpChannel(channel, false, singleMessageChannel);
    }

    public Channel getOrCreateTransactedChannel(AmqpTransactionalConnection connection, Optional<Channel> transactedChannel) throws IOException {
        Channel channel;
        if (transactedChannel.isPresent()) {
            channel = transactedChannel.get();
        } else {
            switch (this.getTransactionStatus()) {
                case STARTED: {
                    channel = connection.createChannel();
                    channel.txSelect();
                    this.bindToTransaction(channel);
                    break;
                }
                default: {
                    channel = connection.createChannel();
                }
            }
        }
        return channel;
    }
}

