/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection.channel;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.CancelCallback;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmCallback;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerShutdownSignalCallback;
import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnCallback;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class MuleAmqpChannel
implements Channel {
    private boolean inTransaction;
    private Channel channel;
    private boolean singleMessageChannel;
    private long lastUsedTimestamp;

    public MuleAmqpChannel(Channel channel, boolean inTransaction) {
        this.inTransaction = inTransaction;
        this.channel = channel;
    }

    public MuleAmqpChannel(Channel channel, boolean inTransaction, boolean singleMessageChannel) {
        this.singleMessageChannel = singleMessageChannel;
        this.inTransaction = inTransaction;
        this.channel = channel;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public boolean isSingleMessageChannel() {
        return this.singleMessageChannel;
    }

    public void addShutdownListener(ShutdownListener listener) {
        this.channel.addShutdownListener(listener);
    }

    public void removeShutdownListener(ShutdownListener listener) {
        this.channel.removeShutdownListener(listener);
    }

    public ShutdownSignalException getCloseReason() {
        return this.channel.getCloseReason();
    }

    public void notifyListeners() {
        this.channel.notifyListeners();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public int getChannelNumber() {
        return this.channel.getChannelNumber();
    }

    public Connection getConnection() {
        return this.channel.getConnection();
    }

    public void close() throws IOException, TimeoutException {
        this.channel.close();
    }

    public void close(int closeCode, String closeMessage) throws IOException, TimeoutException {
        this.channel.close(closeCode, closeMessage);
    }

    public void abort() throws IOException {
        this.channel.abort();
    }

    public void abort(int closeCode, String closeMessage) throws IOException {
        this.channel.abort(closeCode, closeMessage);
    }

    public void addReturnListener(ReturnListener listener) {
        this.channel.addReturnListener(listener);
    }

    public boolean removeReturnListener(ReturnListener listener) {
        return this.channel.removeReturnListener(listener);
    }

    public void clearReturnListeners() {
        this.channel.clearReturnListeners();
    }

    public void addConfirmListener(ConfirmListener listener) {
        this.channel.addConfirmListener(listener);
    }

    public boolean removeConfirmListener(ConfirmListener listener) {
        return this.channel.removeConfirmListener(listener);
    }

    public void clearConfirmListeners() {
        this.channel.clearConfirmListeners();
    }

    public Consumer getDefaultConsumer() {
        return this.channel.getDefaultConsumer();
    }

    public void setDefaultConsumer(Consumer consumer) {
        this.channel.setDefaultConsumer(consumer);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        this.channel.basicQos(prefetchSize, prefetchCount, global);
    }

    public void basicQos(int prefetchCount, boolean global) throws IOException {
        this.channel.basicQos(prefetchCount, global);
    }

    public void basicQos(int prefetchCount) throws IOException {
        this.channel.basicQos(prefetchCount);
    }

    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.channel.basicPublish(exchange, routingKey, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.channel.basicPublish(exchange, routingKey, props, body);
    }

    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.channel.basicPublish(exchange, routingKey, mandatory, immediate, props, body);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.channel.exchangeDeclare(exchange, type);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.channel.exchangeDeclare(exchange, type, durable);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.channel.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.channel.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        this.channel.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
        return this.channel.exchangeDeclarePassive(name);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        return this.channel.exchangeDelete(exchange, ifUnused);
    }

    public void exchangeDeleteNoWait(String exchange, boolean ifUnused) throws IOException {
        this.channel.exchangeDeleteNoWait(exchange, ifUnused);
    }

    public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.channel.exchangeDelete(exchange);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
        return this.channel.exchangeBind(destination, source, routingKey);
    }

    public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.channel.exchangeBind(destination, source, routingKey, arguments);
    }

    public void exchangeBindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.channel.exchangeBindNoWait(destination, source, routingKey, arguments);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
        return this.channel.exchangeUnbind(destination, source, routingKey);
    }

    public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.channel.exchangeUnbind(destination, source, routingKey, arguments);
    }

    public void exchangeUnbindNoWait(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
        this.channel.exchangeUnbindNoWait(destination, source, routingKey, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.channel.queueDeclare();
    }

    public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.channel.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
    }

    public void queueDeclareNoWait(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        this.channel.queueDeclareNoWait(queue, durable, exclusive, autoDelete, arguments);
    }

    public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return this.channel.queueDeclarePassive(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.channel.queueDelete(queue);
    }

    public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return this.channel.queueDelete(queue, ifUnused, ifEmpty);
    }

    public void queueDeleteNoWait(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        this.channel.queueDeleteNoWait(queue, ifUnused, ifEmpty);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.channel.queueBind(queue, exchange, routingKey);
    }

    public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.channel.queueBind(queue, exchange, routingKey, arguments);
    }

    public void queueBindNoWait(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        this.channel.queueBindNoWait(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.channel.queueUnbind(queue, exchange, routingKey);
    }

    public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return this.channel.queueUnbind(queue, exchange, routingKey, arguments);
    }

    public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return this.channel.queuePurge(queue);
    }

    public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
        return this.channel.basicGet(queue, autoAck);
    }

    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.channel.basicAck(deliveryTag, multiple);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
        this.channel.basicNack(deliveryTag, multiple, requeue);
    }

    public void basicReject(long deliveryTag, boolean requeue) throws IOException {
        this.channel.basicReject(deliveryTag, requeue);
    }

    public String basicConsume(String queue, Consumer callback) throws IOException {
        return this.channel.basicConsume(queue, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, callback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, arguments, callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, callback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
    }

    public void basicCancel(String consumerTag) throws IOException {
        this.channel.basicCancel(consumerTag);
    }

    public AMQP.Basic.RecoverOk basicRecover() throws IOException {
        return this.channel.basicRecover();
    }

    public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return this.channel.basicRecover(requeue);
    }

    public AMQP.Tx.SelectOk txSelect() throws IOException {
        return this.channel.txSelect();
    }

    public AMQP.Tx.CommitOk txCommit() throws IOException {
        return this.channel.txCommit();
    }

    public AMQP.Tx.RollbackOk txRollback() throws IOException {
        return this.channel.txRollback();
    }

    public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
        return this.channel.confirmSelect();
    }

    public long getNextPublishSeqNo() {
        return this.channel.getNextPublishSeqNo();
    }

    public boolean waitForConfirms() throws InterruptedException {
        return this.channel.waitForConfirms();
    }

    public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
        return this.channel.waitForConfirms(timeout);
    }

    public void waitForConfirmsOrDie() throws IOException, InterruptedException {
        this.channel.waitForConfirmsOrDie();
    }

    public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
        this.channel.waitForConfirmsOrDie(timeout);
    }

    public void asyncRpc(Method method) throws IOException {
        this.channel.asyncRpc(method);
    }

    public Command rpc(Method method) throws IOException {
        return this.channel.rpc(method);
    }

    public long messageCount(String queue) throws IOException {
        return this.channel.messageCount(queue);
    }

    public long consumerCount(String queue) throws IOException {
        return this.channel.consumerCount(queue);
    }

    public ReturnListener addReturnListener(ReturnCallback returnCallback) {
        return this.channel.addReturnListener(returnCallback);
    }

    public ConfirmListener addConfirmListener(ConfirmCallback ackCallback, ConfirmCallback nackCallback) {
        return this.channel.addConfirmListener(ackCallback, nackCallback);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type) throws IOException {
        return this.channel.exchangeDeclare(exchange, type);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable) throws IOException {
        return this.channel.exchangeDeclare(exchange, type, durable);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return this.channel.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
    }

    public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        return this.channel.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
    }

    public void exchangeDeclareNoWait(String exchange, BuiltinExchangeType type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
        this.channel.exchangeDeclareNoWait(exchange, type, durable, autoDelete, internal, arguments);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.channel.basicConsume(queue, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, arguments, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, shutdownSignalCallback);
    }

    public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, DeliverCallback deliverCallback, CancelCallback cancelCallback, ConsumerShutdownSignalCallback shutdownSignalCallback) throws IOException {
        return this.channel.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, deliverCallback, cancelCallback, shutdownSignalCallback);
    }

    public CompletableFuture<Command> asyncCompletableRpc(Method method) throws IOException {
        return this.channel.asyncCompletableRpc(method);
    }

    public void updateLastUsed() {
        this.lastUsedTimestamp = System.currentTimeMillis();
    }

    public long getLastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }
}

