/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.connection.channel;

import com.mule.extensions.amqp.api.config.QualityOfService;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import com.mule.extensions.amqp.internal.connection.channel.ChannelProvider;
import com.mule.extensions.amqp.internal.connection.channel.MuleAmqpChannel;
import com.mule.extensions.amqp.internal.connection.channel.TransactionStatus;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalChannelProvider
implements ChannelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionalChannelProvider.class);
    private static final TransactionalChannelProvider INSTANCE = new TransactionalChannelProvider();

    private TransactionalChannelProvider() {
    }

    public static TransactionalChannelProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public MuleAmqpChannel getChannel(AmqpTransactionalConnection connection, AmqpChannelManager channelManager, OperationTransactionalAction transactionalAction, QualityOfService qualityOfService, boolean singleMessageChannel) throws IOException {
        LOGGER.debug("Creating transactional muleAmpqChannel, bypassing pool");
        Channel channel = channelManager.getOrCreateTransactedChannel(connection, channelManager.getTransactedChannel());
        boolean isInTransaction = !channelManager.getTransactionStatus().equals((Object)TransactionStatus.NONE);
        return new MuleAmqpChannel(channel, isInTransaction, singleMessageChannel);
    }
}

