/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.entity;

import com.mule.extensions.amqp.api.model.ExchangeDefinition;
import com.mule.extensions.amqp.internal.entity.AmqpDeclarationException;
import com.mule.extensions.amqp.internal.entity.AmqpDeclarer;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpExchangeDeclarer
implements AmqpDeclarer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpExchangeDeclarer.class);
    private Channel channel;
    private ExchangeDefinition exchangeDefinition;
    private String exchangeName;

    public AmqpExchangeDeclarer(Channel channel, ExchangeDefinition exchangeDefinition, String exchangeName) {
        this.channel = channel;
        this.exchangeDefinition = exchangeDefinition;
        this.exchangeName = exchangeName;
    }

    @Override
    public void declarePassive() throws AmqpDeclarationException {
        try {
            this.channel.exchangeDeclarePassive(this.exchangeName);
        }
        catch (IOException e) {
            throw new AmqpDeclarationException("Error during active declaration of exchange " + this.exchangeName + ":" + e.getMessage(), e);
        }
    }

    @Override
    public void declareActive() throws AmqpDeclarationException {
        try {
            this.channel.exchangeDeclare(this.exchangeName, this.exchangeDefinition.getType().name().toLowerCase(), this.exchangeDefinition.getRemovalStrategy().isDurable(), this.exchangeDefinition.getRemovalStrategy().isAutoDelete(), new HashMap());
        }
        catch (IOException e) {
            throw new AmqpDeclarationException("Error during active declaration of exchange " + this.exchangeName + ":" + e.getMessage(), e);
        }
    }

    public boolean exchangeExists() {
        try {
            if (this.exchangeName.contentEquals("")) {
                return true;
            }
            this.channel.exchangeDeclarePassive(this.exchangeName);
        }
        catch (IOException e) {
            return false;
        }
        LOGGER.debug("Validated presence of exchange: " + this.exchangeName);
        return true;
    }
}

