/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.message;

import com.mule.extensions.amqp.api.config.DeliveryMode;
import com.mule.extensions.amqp.api.model.Properties;
import com.mule.extensions.amqp.internal.utils.ObjectToMapTransformer;
import com.rabbitmq.client.Envelope;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.runtime.core.api.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpMessage.class);
    private final String consumerTag;
    private final Envelope envelope;
    private final byte[] body;
    private Map<String, Object> headers;
    private Properties properties;

    public AmqpMessage(String consumerTag, Envelope envelope, Properties properties, Map<String, Object> headers, byte[] body) {
        this.consumerTag = consumerTag;
        this.envelope = envelope;
        this.properties = properties;
        this.body = body;
        this.headers = this.transformHeaders(headers);
    }

    private Map<String, Object> transformHeaders(Map<String, Object> originalHeaders) {
        int minorRuntimeVersion;
        if (originalHeaders == null || originalHeaders.isEmpty()) {
            return originalHeaders;
        }
        String javaVersion = System.getProperty("java.version");
        int mayorJavaVersion = Integer.parseInt(javaVersion.split("\\.")[0]);
        String runtimeVersion = MuleManifest.getProductVersion();
        int mayorRuntimeVersion = runtimeVersion != null ? Integer.parseInt(runtimeVersion.split("\\.")[0]) : 4;
        int n = minorRuntimeVersion = runtimeVersion != null ? Integer.parseInt(runtimeVersion.split("\\.")[1]) : 1;
        if (mayorJavaVersion < 17 && mayorRuntimeVersion == 4 && minorRuntimeVersion < 6) {
            LOGGER.debug("Returning original headers as transformation is not supported in this runtime version");
            return originalHeaders;
        }
        LOGGER.debug("Calling ObjectToMapTransformer.transformValue for each header");
        HashMap<String, Object> transformedHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : originalHeaders.entrySet()) {
            Object valueConverted = ObjectToMapTransformer.transformValue(entry.getValue());
            transformedHeaders.put(entry.getKey(), valueConverted);
            LOGGER.debug("Transformed header {} to {}", (Object)entry.getKey(), valueConverted);
        }
        return transformedHeaders;
    }

    public String getConsumerTag() {
        return this.consumerTag;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setDeliveryMode(DeliveryMode deliveryMode) {
        this.properties.setDeliveryMode(deliveryMode);
    }

    public void setPriority(int priority) {
        this.properties.setPriority(priority);
    }

    public String getReplyTo() {
        return this.properties.getReplyTo();
    }

    public void setReplyTo(String replyTo) {
        this.properties.setReplyTo(replyTo);
    }

    public byte[] getBody() {
        return this.body;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

