/*
 * Decompiled with CFR 0.152.
 */
package com.mule.extensions.amqp.internal.operation;

import com.mule.extensions.amqp.api.config.DeliveryMode;
import com.mule.extensions.amqp.api.exception.AmqpExtensionException;
import com.mule.extensions.amqp.api.exception.AmqpPublishErrorTypeProvider;
import com.mule.extensions.amqp.api.exception.AmqpPublishException;
import com.mule.extensions.amqp.api.message.AmqpMessageBuilder;
import com.mule.extensions.amqp.api.model.ExchangeDefinitionParameters;
import com.mule.extensions.amqp.api.model.RoutingConfiguration;
import com.mule.extensions.amqp.internal.common.AmqpCommons;
import com.mule.extensions.amqp.internal.config.AmqpConfig;
import com.mule.extensions.amqp.internal.connection.AmqpTransactionalConnection;
import com.mule.extensions.amqp.internal.connection.channel.AmqpChannelManager;
import com.mule.extensions.amqp.internal.connection.channel.ChannelPool;
import com.mule.extensions.amqp.internal.connection.channel.ChannelProvider;
import com.mule.extensions.amqp.internal.connection.channel.ChannelProviderFactory;
import com.mule.extensions.amqp.internal.connection.channel.MuleAmqpChannel;
import com.mule.extensions.amqp.internal.exception.resolver.PublishExceptionResolver;
import com.mule.extensions.amqp.internal.model.message.Message;
import com.mule.extensions.amqp.internal.publish.AmqpPublishParameters;
import com.mule.extensions.amqp.internal.publisher.AmqpPublisherCommons;
import com.mule.extensions.amqp.internal.publisher.DefaultAmqpMessagePublisher;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmqpPublish {
    private static final Logger LOGGER = LoggerFactory.getLogger(AmqpPublish.class);
    private PublishExceptionResolver exceptionResolver = new PublishExceptionResolver();
    @Inject
    private AmqpChannelManager channelManager;
    @Inject
    private TransformationService transformationService;
    @Inject
    private SchedulerService schedulerService;

    @Throws(value={AmqpPublishErrorTypeProvider.class})
    public void publish(@Config AmqpConfig config, @Connection AmqpTransactionalConnection connection, @Optional(defaultValue="") @Summary(value="The name of the exchange to publish the message to") String exchangeName, @ParameterGroup(name="Exchange Definition Configuration") ExchangeDefinitionParameters exchangeDefinitionParameters, @ParameterGroup(name="Routing Configuration") RoutingConfiguration routingConfiguration, @ConfigOverride @Optional @Summary(value="The delivery mode to use when publishing to the AMQP broker") DeliveryMode deliveryMode, @Summary(value="A builder for the message that will be published") @ParameterGroup(name="Message", showInDsl=true) AmqpMessageBuilder messageBuilder, @ParameterGroup(name="Publish Configuration") AmqpPublishParameters overrides, OperationTransactionalAction transactionalActionPublish, @ConfigOverride OutboundCorrelationStrategy sendCorrelationId, @ConfigOverride boolean createFallbackExchange, CorrelationInfo correlationInfo) throws AmqpExtensionException {
        ChannelPool channelPool = null;
        MuleAmqpChannel channel = null;
        try {
            LOGGER.debug("Begin [publish] to : {}", (Object)exchangeName);
            AmqpPublisherCommons.checkBrokerNotBlocked(connection);
            channelPool = ChannelPool.getInstance(connection, this.schedulerService);
            ChannelProvider provider = ChannelProviderFactory.getProvider(connection, this.schedulerService, transactionalActionPublish, this.channelManager);
            channel = provider.getChannel(connection, this.channelManager, transactionalActionPublish, config.getQualityOfService(), true);
            if (Objects.isNull((Object)exchangeDefinitionParameters.getSkipExchangeValidation())) {
                channel = AmqpCommons.declareFallbackExchangeIfNeeded(connection, exchangeName, exchangeDefinitionParameters.getFallbackExchangeDefinition(), transactionalActionPublish, channel, this.channelManager, createFallbackExchange);
            }
            DefaultAmqpMessagePublisher messagePublisher = DefaultAmqpMessagePublisher.Builder.newInstance().withChannel(channel).withExchangeName(exchangeName).withRequestBrokerConfirms(AmqpPublisherCommons.resolveRequestBrokerConfirms(config, overrides)).withReturnedMessageExchange(AmqpPublisherCommons.resolvedReturnedMessageExchange(config, overrides)).build();
            messageBuilder.overridePriorityIfNeeded(config.getPublisherConfig().getPriority());
            List<String> routingKeys = routingConfiguration.getRoutingKeys();
            Message message = messageBuilder.build(AmqpCommons.resolveOverride(config.getPublisherConfig().isImmediate(), overrides.isImmediate()), AmqpCommons.resolveOverride(config.getPublisherConfig().isMandatory(), overrides.isMandatory()), StringUtils.join(routingKeys, (char)','), exchangeName, config.getContentType(), config.getEncoding(), deliveryMode, sendCorrelationId, correlationInfo, this.transformationService);
            messagePublisher.publish(message);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Finished [publish] to the exchange: [%s] using channel number [%s]", exchangeName, channel.getChannelNumber()));
            }
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while publishing a message to the exchange [%s]: %s", exchangeName, e.getMessage());
            throw new AmqpPublishException(msg, (Exception)((Object)this.exceptionResolver.resolveException(e)));
        }
        finally {
            if (!(Objects.isNull(channelPool) || Objects.isNull(channel) || channel.isInTransaction())) {
                channelPool.releaseChannel(this.channelManager, transactionalActionPublish, config.getQualityOfService(), true, channel);
            }
        }
    }
}

