/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.api;

import com.mulesoft.connector.as2.api.AS2Compression;
import com.mulesoft.connector.as2.api.EncodingType;
import com.mulesoft.connector.as2.api.EncryptionAlgorithm;
import com.mulesoft.connector.as2.api.HashAlgorithm;
import com.mulesoft.connector.as2.api.RequestReceipt;
import java.io.Serializable;
import java.util.Objects;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class PrepareSendAttributes
implements Serializable {
    private static final long serialVersionUID = -321453669738326414L;
    @Parameter
    @DisplayName(value="AS2 From Name")
    private String fromName;
    @Parameter
    @DisplayName(value="AS2 To Name")
    private String toName;
    @Parameter
    @DisplayName(value="Signature Algorithm")
    @Optional(defaultValue="UNSIGNED")
    private HashAlgorithm micAlg;
    @Parameter
    @DisplayName(value="Encryption Algorithm")
    @Optional(defaultValue="UNENCRYPTED")
    private EncryptionAlgorithm encryptionAlgorithm;
    @Parameter
    @DisplayName(value="Transfer Encoding")
    @Optional(defaultValue="BINARY")
    private EncodingType transferEncoding;
    @Parameter
    @DisplayName(value="Request Receipt")
    private RequestReceipt requestReceipt;
    @Parameter
    @DisplayName(value="Compression")
    @Optional
    private AS2Compression as2Compression;
    @Parameter
    @DisplayName(value="Partner Pem Content")
    @Summary(value="Should include the certs/public key of the partner. This will be used for both signature verification and encryption")
    private String partnerPemContent;
    @Parameter
    @DisplayName(value="Self Pem Content")
    @Summary(value="Should include the certs/public and private keys of the organisation. This will be used for both signing and decryption")
    private String selfPemContent;
    @Parameter
    @DisplayName(value="Self Private Key Password")
    @Summary(value="Private key password in self pem content")
    @Optional
    private String privateKeyPassword;
    @Parameter
    @DisplayName(value="Receipt Delivery URL")
    @Optional
    private String receiptDeliveryUrl;
    @Parameter
    @DisplayName(value="Signature Algorithm")
    @Optional(defaultValue="UNSIGNED")
    private HashAlgorithm mdnMicAlg;
    @Parameter
    @DisplayName(value="Respond To Email Address")
    @Example(value="example@company.com")
    private String respondToEmailAddress;

    public PrepareSendAttributes() {
    }

    public PrepareSendAttributes(String fromName, String respondToEmailAddress, String toName, HashAlgorithm micAlg, HashAlgorithm mdnMicAlg, EncryptionAlgorithm encryptionAlgorithm, EncodingType transferEncoding, RequestReceipt requestReceipt, AS2Compression as2Compression, String partnerPemContent, String selfPemContent, String privateKeyPassword, String receiptDeliveryUrl) {
        this.fromName = fromName;
        this.respondToEmailAddress = respondToEmailAddress;
        this.toName = toName;
        this.micAlg = micAlg;
        this.mdnMicAlg = mdnMicAlg;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.transferEncoding = transferEncoding;
        this.requestReceipt = requestReceipt;
        this.as2Compression = as2Compression;
        this.partnerPemContent = partnerPemContent;
        this.selfPemContent = selfPemContent;
        this.privateKeyPassword = privateKeyPassword;
        this.receiptDeliveryUrl = receiptDeliveryUrl;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getRespondToEmailAddress() {
        return this.respondToEmailAddress;
    }

    public String getToName() {
        return this.toName;
    }

    public HashAlgorithm getMicAlg() {
        return this.micAlg;
    }

    public HashAlgorithm getMdnMicAlg() {
        return this.mdnMicAlg;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public EncodingType getTransferEncoding() {
        return this.transferEncoding;
    }

    public RequestReceipt getRequestReceipt() {
        return this.requestReceipt;
    }

    public AS2Compression getAs2Compression() {
        return this.as2Compression;
    }

    public String getPartnerPemContent() {
        return this.partnerPemContent;
    }

    public String getSelfPemContent() {
        return this.selfPemContent;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public String getReceiptDeliveryUrl() {
        return this.receiptDeliveryUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrepareSendAttributes that = (PrepareSendAttributes)o;
        return this.as2Compression == that.as2Compression && this.encryptionAlgorithm == that.encryptionAlgorithm && Objects.equals(this.fromName, that.fromName) && this.mdnMicAlg == that.mdnMicAlg && this.micAlg == that.micAlg && Objects.equals(this.partnerPemContent, that.partnerPemContent) && Objects.equals(this.privateKeyPassword, that.privateKeyPassword) && Objects.equals(this.receiptDeliveryUrl, that.receiptDeliveryUrl) && this.requestReceipt == that.requestReceipt && Objects.equals(this.respondToEmailAddress, that.respondToEmailAddress) && Objects.equals(this.selfPemContent, that.selfPemContent) && Objects.equals(this.toName, that.toName) && this.transferEncoding == that.transferEncoding;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.as2Compression, this.encryptionAlgorithm, this.fromName, this.mdnMicAlg, this.micAlg, this.partnerPemContent, this.privateKeyPassword, this.receiptDeliveryUrl, this.requestReceipt, this.respondToEmailAddress, this.selfPemContent, this.toName, this.transferEncoding});
    }
}

