/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.model.builder;

import com.mulesoft.connector.as2.api.AS2Compression;
import com.mulesoft.connector.as2.api.EncodingType;
import com.mulesoft.connector.as2.api.EncryptionAlgorithm;
import com.mulesoft.connector.as2.api.HashAlgorithm;
import com.mulesoft.connector.as2.api.PrepareSendAttributes;
import com.mulesoft.connector.as2.api.RequestReceipt;

public class PrepareSendAttributesBuilder {
    private String fromName;
    private String respondToEmailAddress;
    private String toName;
    private HashAlgorithm micAlg;
    private HashAlgorithm mdnMicAlg;
    private EncryptionAlgorithm encryptionAlgorithm;
    private EncodingType transferEncoding;
    private RequestReceipt requestReceipt;
    private AS2Compression as2Compression;
    private String partnerPemContent;
    private String selfPemContent;
    private String privateKeyPassword;
    private String receiptDeliveryUrl;

    public PrepareSendAttributes build() {
        return new PrepareSendAttributes(this.fromName, this.respondToEmailAddress, this.toName, this.micAlg, this.mdnMicAlg, this.encryptionAlgorithm, this.transferEncoding, this.requestReceipt, this.as2Compression, this.partnerPemContent, this.selfPemContent, this.privateKeyPassword, this.receiptDeliveryUrl);
    }

    public PrepareSendAttributesBuilder withFromName(String fromName) {
        this.fromName = fromName;
        return this;
    }

    public PrepareSendAttributesBuilder withRespondToEmailAddress(String respondToEmailAddress) {
        this.respondToEmailAddress = respondToEmailAddress;
        return this;
    }

    public PrepareSendAttributesBuilder withToName(String toName) {
        this.toName = toName;
        return this;
    }

    public PrepareSendAttributesBuilder withMicAlg(HashAlgorithm micAlg) {
        this.micAlg = micAlg;
        return this;
    }

    public PrepareSendAttributesBuilder withMdnMicAlg(HashAlgorithm mdnMicAlg) {
        this.mdnMicAlg = mdnMicAlg;
        return this;
    }

    public PrepareSendAttributesBuilder withEncryptionAlgorithm(EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public PrepareSendAttributesBuilder withTransferEncoding(EncodingType transferEncoding) {
        this.transferEncoding = transferEncoding;
        return this;
    }

    public PrepareSendAttributesBuilder withRequestReceipt(RequestReceipt requestReceipt) {
        this.requestReceipt = requestReceipt;
        return this;
    }

    public PrepareSendAttributesBuilder withAs2Compression(AS2Compression as2Compression) {
        this.as2Compression = as2Compression;
        return this;
    }

    public PrepareSendAttributesBuilder withPartnerPemContent(String partnerPemContent) {
        this.partnerPemContent = partnerPemContent;
        return this;
    }

    public PrepareSendAttributesBuilder withSelfPemContent(String selfPemContent) {
        this.selfPemContent = selfPemContent;
        return this;
    }

    public PrepareSendAttributesBuilder withPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
        return this;
    }

    public PrepareSendAttributesBuilder withReceiptDeliveryUrl(String receiptDeliveryUrl) {
        this.receiptDeliveryUrl = receiptDeliveryUrl;
        return this;
    }
}

