/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.operation;

import com.mulesoft.connector.as2.api.AS2ReceiveAttributes;
import com.mulesoft.connector.as2.internal.crypto.AS2PEMParser;
import com.mulesoft.connector.as2.internal.enums.RequiredSecurityLevel;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.error.provider.ReceiveErrorTypeProvider;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.model.builder.ReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.param.RequestHandlerParameters;
import com.mulesoft.connector.as2.internal.receive.AbstractReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.receive.MDN;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import java.io.InputStream;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2RequestHandlerOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2RequestHandlerOperation.class);
    private ReceiveHandler receiveHandler = new ReceiveHandler().withBoundaryIdentifierGeneratorFactory(new BoundaryIdentifierGeneratorFactory()).withAS2MessageIdGeneratorFactory(new AS2MessageIdGeneratorFactory());

    @Throws(value={ReceiveErrorTypeProvider.class})
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, AS2ReceiveAttributes> requestHandler(@ParameterGroup(name="Request Parameters") RequestHandlerParameters parameters, @Content(primary=true) @DisplayName(value="Http Request Content") InputStream requestContent, @DisplayName(value="Http Request Headers") MultiMap<String, String> headers) {
        CaseInsensitiveMultiMap httpHeaders = this.getCaseInsensitiveHttpHeadersMap(headers);
        final ReceiveAttributesBuilder receiveAttributesBuilder = new ReceiveAttributesBuilder();
        RequestKeyStore requestKeyStore = this.getRequestKeyStore(parameters);
        final Result.Builder resultBuilder = Result.builder();
        ReceiveHandlerCallback receiveHandlerCallback = new ReceiveHandlerCallback(){

            public void notifyResult(InputStream content, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, MimePart mimePart) {
                if (dispositionType != null && dispositionType != DispositionType.PROCESSED && LOGGER.isErrorEnabled()) {
                    LOGGER.error(String.format("Will not execute the rest of the flow as there is an AS2 processing error:\nStatus: %s\nStatus Modifier: %s\nDescription: %s", dispositionType.getStatus(), dispositionType.getStatusModifier(), dispositionType.getStatusDescription()));
                }
                MDN mdn = signedMimeMessageAttributes.getMdn();
                receiveAttributesBuilder.withProcessed(mdn.isProcessed());
                if (mdn.getMdnMimePart() != null) {
                    receiveAttributesBuilder.withMdnResponse(IOUtils.toString((InputStream)mdn.getMdnMimePart().getContent())).withMdnHeaders((MultiMap<String, String>)mdn.getMdnHttpHeaders());
                }
                resultBuilder.attributes((Object)receiveAttributesBuilder.build()).output((Object)content);
            }

            public void notifyError(Throwable e, MimePart mimePart) {
                if (e instanceof AS2ExtensionException) {
                    throw (AS2ExtensionException)e;
                }
                throw new AS2ExtensionException("Unexpected error receiving AS2 message", e);
            }

            public void notifyException(AS2ExtensionException exception) {
                super.notifyException(exception);
                throw exception;
            }
        };
        RequiredSecurityLevel securityLevel = this.getRequiredSecurityLevel(parameters);
        this.receiveHandler.receiveAS2Message(httpHeaders, requestContent, (AbstractReceiveAttributesBuilder)receiveAttributesBuilder, requestKeyStore, receiveHandlerCallback, false, securityLevel);
        return resultBuilder.build();
    }

    private RequiredSecurityLevel getRequiredSecurityLevel(RequestHandlerParameters parameters) {
        RequiredSecurityLevel securityLevel = null;
        if (parameters.getSecurityLevel() != null) {
            securityLevel = RequiredSecurityLevel.findRequiredSecurityLevel((String)parameters.getSecurityLevel().name());
        }
        return securityLevel;
    }

    RequestKeyStore getRequestKeyStore(RequestHandlerParameters parameters) {
        String selfPemContent = parameters.getSelfPemContent();
        String partnerPemContent = parameters.getPartnerPemContent();
        RequestKeyStore requestKeyStore = new RequestKeyStore();
        if (selfPemContent != null) {
            LOGGER.debug("Retrieving key information from Self Pem content.");
            AS2PEMParser selfPemParser = new AS2PEMParser().withPemContent(selfPemContent).withPassword(parameters.getPrivateKeyPassword()).build();
            requestKeyStore.setSelfCertificate(selfPemParser.getCertificate());
            requestKeyStore.setSelfPrivateKey(selfPemParser.getPrivateKey());
        }
        if (partnerPemContent != null) {
            LOGGER.debug("Retrieving key information from Partner Pem content.");
            AS2PEMParser partnerPemParser = new AS2PEMParser().withPemContent(partnerPemContent).build();
            requestKeyStore.setPartnerPublicKey(partnerPemParser.getPublicKey());
        }
        return requestKeyStore;
    }

    private CaseInsensitiveMultiMap getCaseInsensitiveHttpHeadersMap(MultiMap headers) {
        CaseInsensitiveMultiMap httpHeaders = new CaseInsensitiveMultiMap();
        httpHeaders.putAll(headers);
        return httpHeaders;
    }
}

