/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.api;

import com.mulesoft.connector.as2.api.HashAlgorithm;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class AS2MdnAttributes
implements Serializable {
    private static final long serialVersionUID = -8188452777413205724L;
    @Parameter
    @DisplayName(value="From Name")
    private String fromName;
    @Parameter
    @DisplayName(value="To Name")
    private String toName;
    @Parameter
    @DisplayName(value="AS2 Message ID")
    private String as2MessageId;
    @Parameter
    @DisplayName(value="HTTP Headers")
    private MultiMap<String, String> headers;
    @Parameter
    @DisplayName(value="Original AS2 Message ID")
    private String originalAS2MessageId;
    @Parameter
    @DisplayName(value="MDN Processed Status")
    private boolean mdnProcessed;
    @Parameter
    @DisplayName(value="MDN Report Content")
    private MultiMap<String, List<String>> dispositionContent;
    @Parameter
    @DisplayName(value="Full Report Content")
    private String reportText;
    @Parameter
    @DisplayName(value="Received MIC")
    private String mdnMic;
    @Parameter
    @DisplayName(value="Calculated MIC Algorithm")
    private HashAlgorithm mdnAlg;

    public AS2MdnAttributes(String fromName, String toName, String as2MessageId, MultiMap<String, String> headers, String originalAS2MessageId, boolean mdnProcessed, MultiMap<String, List<String>> dispositionContent, String reportText, String mdnMic, HashAlgorithm mdnAlg) {
        this.fromName = fromName;
        this.toName = toName;
        this.as2MessageId = as2MessageId;
        this.headers = headers;
        this.originalAS2MessageId = originalAS2MessageId;
        this.mdnProcessed = mdnProcessed;
        this.dispositionContent = dispositionContent;
        this.reportText = reportText;
        this.mdnMic = mdnMic;
        this.mdnAlg = mdnAlg;
    }

    public String getFromName() {
        return this.fromName;
    }

    public String getToName() {
        return this.toName;
    }

    public String getAs2MessageId() {
        return this.as2MessageId;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public String getOriginalAS2MessageId() {
        return this.originalAS2MessageId;
    }

    public boolean isMdnProcessed() {
        return this.mdnProcessed;
    }

    public MultiMap getDispositionContent() {
        return this.dispositionContent;
    }

    public String getReportText() {
        return this.reportText;
    }

    public String getMdnMic() {
        return this.mdnMic;
    }

    public HashAlgorithm getMdnAlg() {
        return this.mdnAlg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AS2MdnAttributes that = (AS2MdnAttributes)o;
        return this.mdnProcessed == that.mdnProcessed && Objects.equals(this.as2MessageId, that.as2MessageId) && Objects.equals(this.dispositionContent, that.dispositionContent) && Objects.equals(this.fromName, that.fromName) && Objects.equals(this.headers, that.headers) && this.mdnAlg == that.mdnAlg && Objects.equals(this.mdnMic, that.mdnMic) && Objects.equals(this.originalAS2MessageId, that.originalAS2MessageId) && Objects.equals(this.reportText, that.reportText) && Objects.equals(this.toName, that.toName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.as2MessageId, this.dispositionContent, this.fromName, this.headers, this.mdnAlg, this.mdnMic, this.mdnProcessed, this.originalAS2MessageId, this.reportText, this.toName});
    }
}

