/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.operation;

import com.mulesoft.connector.as2.api.AS2SendAttributes;
import com.mulesoft.connector.as2.api.HashAlgorithm;
import com.mulesoft.connector.as2.api.PrepareSendAttributes;
import com.mulesoft.connector.as2.internal.crypto.AS2PEMParser;
import com.mulesoft.connector.as2.internal.enums.AS2Compression;
import com.mulesoft.connector.as2.internal.enums.EncodingType;
import com.mulesoft.connector.as2.internal.enums.EncryptionAlgorithm;
import com.mulesoft.connector.as2.internal.enums.RequestReceipt;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.error.provider.PrepareSendErrorTypeProvider;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.model.builder.SendAttributesBuilder;
import com.mulesoft.connector.as2.internal.param.PrepareSendParameters;
import com.mulesoft.connector.as2.internal.send.AS2MessageBuilder;
import java.io.InputStream;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2PrepareSendOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2PrepareSendOperation.class);
    BoundaryIdentifierGeneratorFactory boundaryIdentifierGeneratorFactory = new BoundaryIdentifierGeneratorFactory();
    AS2MessageIdGeneratorFactory as2MessageIdGeneratorFactory = new AS2MessageIdGeneratorFactory();

    @Throws(value={PrepareSendErrorTypeProvider.class})
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, AS2SendAttributes> prepareSend(@ParameterGroup(name="Prepare Send Parameters") PrepareSendParameters prepareSendParameters, @Content(primary=true) @DisplayName(value="Content Stream") @Summary(value="The content to be sent.") InputStream content) {
        PrepareSendAttributes attributes = prepareSendParameters.getAttributes();
        LOGGER.trace("\nAS2 FROM: " + attributes.getFromName() + "\nAS2 TO: " + attributes.getToName() + "\nSignature Alg: " + (Object)((Object)attributes.getMicAlg()) + "\nEncryption Alg: " + (Object)((Object)attributes.getEncryptionAlgorithm()) + "\nTransfer Encoding: " + (Object)((Object)attributes.getTransferEncoding()) + "\nCompression: " + (Object)((Object)attributes.getAs2Compression()) + "\nSignature Mdn Alg: " + (Object)((Object)attributes.getMdnMicAlg()));
        LOGGER.trace("\nPrepare SEND: Self PEM Content:\n" + attributes.getSelfPemContent() + "\nPassword: " + attributes.getPrivateKeyPassword());
        LOGGER.trace("\nPrepare SEND: Partner PEM Content:\n" + attributes.getPartnerPemContent());
        LOGGER.trace("\nPrepare SEND: Validate Certificate expiration: " + attributes.getValidateCertificate());
        AS2MessageBuilder as2MessageBuilder = new AS2MessageBuilder().withMimeType(prepareSendParameters.getAs2MimeType()).withFileName(prepareSendParameters.getFileName()).withContentDescription(prepareSendParameters.getContentDescription()).withContent(content).withSender(attributes.getFromName()).withRespondToEmail(attributes.getRespondToEmailAddress()).withReceiver(attributes.getToName()).withReceiptDeliveryOption(attributes.getReceiptDeliveryUrl()).withMdnSignatureHashAlgorithm(com.mulesoft.connector.as2.internal.enums.HashAlgorithm.findByAlgorithm((String)attributes.getMdnMicAlg().algorithm())).withBoundaryIdentifierGeneratorFactory(this.boundaryIdentifierGeneratorFactory).withAS2MessageIdGeneratorFactory(this.as2MessageIdGeneratorFactory);
        if (attributes.getAs2Compression() != null) {
            as2MessageBuilder.withCompression(AS2Compression.findByCanonicalName((String)attributes.getAs2Compression().getCanonicalName()));
        }
        if (attributes.getTransferEncoding() != null) {
            as2MessageBuilder.withContentTransferEncoding(EncodingType.findByCanonicalName((String)attributes.getTransferEncoding().getCanonicalName()));
        }
        if (attributes.getRequestReceipt() != null) {
            as2MessageBuilder.withReceiptRequired(RequestReceipt.findReceiptRequired((String)attributes.getRequestReceipt().name()));
        }
        if (attributes.getMicAlg() != null && attributes.getMicAlg() != HashAlgorithm.UNSIGNED) {
            if (attributes.getSelfPemContent() == null) {
                throw new AS2ExtensionException("Signed messages must be configured with a KeyStore", AS2ErrorType.CONFIGURATION);
            }
            LOGGER.debug("Retrieving key information from Self Pem content.");
            AS2PEMParser selfPemParser = new AS2PEMParser().withPemContent(attributes.getSelfPemContent()).withPassword(attributes.getPrivateKeyPassword()).build();
            as2MessageBuilder.withSignatureHashAlgorithm(com.mulesoft.connector.as2.internal.enums.HashAlgorithm.findByAlgorithm((String)attributes.getMicAlg().algorithm())).withPrivateKey(selfPemParser.getPrivateKey());
            if (attributes.getValidateCertificate()) {
                as2MessageBuilder.withSelfCertificate(selfPemParser.getCertificateWithExpirationValidation());
            } else {
                as2MessageBuilder.withSelfCertificate(selfPemParser.getCertificate());
            }
        }
        if (attributes.getEncryptionAlgorithm() != null) {
            if (attributes.getPartnerPemContent() == null) {
                throw new AS2ExtensionException("Encrypted messages must be configured with a TrustStore", AS2ErrorType.CONFIGURATION);
            }
            LOGGER.debug("Retrieving key information from Partner Pem content.");
            AS2PEMParser partnerPemParser = new AS2PEMParser().withPemContent(attributes.getPartnerPemContent()).build();
            as2MessageBuilder.withEncryptionAlgorithm(EncryptionAlgorithm.valueOf((String)attributes.getEncryptionAlgorithm().name()));
            if (attributes.getValidateCertificate()) {
                as2MessageBuilder.withPartnerCertificate(partnerPemParser.getCertificateWithExpirationValidation());
            } else {
                as2MessageBuilder.withPartnerCertificate(partnerPemParser.getCertificate());
            }
        }
        as2MessageBuilder.build();
        MultiMap httpHeaders = as2MessageBuilder.getHeaders();
        SendAttributesBuilder sendAttributesBuilder = new SendAttributesBuilder().withHeaders((MultiMap<String, String>)httpHeaders).withAs2MessageId((String)httpHeaders.get((Object)"Message-ID")).withFromName(attributes.getFromName()).withToName(attributes.getToName());
        return Result.builder().output((Object)as2MessageBuilder.getFinalisedAs2Message().asInputStream()).attributes((Object)sendAttributesBuilder.build()).build();
    }
}

