/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.operation;

import com.mulesoft.connector.as2.api.AS2MdnAttributes;
import com.mulesoft.connector.as2.api.HashAlgorithm;
import com.mulesoft.connector.as2.internal.crypto.AS2PEMParser;
import com.mulesoft.connector.as2.internal.crypto.ValidCertificate;
import com.mulesoft.connector.as2.internal.error.AS2ErrorType;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.error.provider.MDNHandlerErrorTypeProvider;
import com.mulesoft.connector.as2.internal.mime.MDNReport;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.parse.MimeParserController;
import com.mulesoft.connector.as2.internal.mime.validate.MimePartValidator;
import com.mulesoft.connector.as2.internal.mime.validate.MimeValidatorController;
import com.mulesoft.connector.as2.internal.mime.validate.SignedMimeMultipartValidator;
import com.mulesoft.connector.as2.internal.model.builder.AS2MdnAttributesBuilder;
import com.mulesoft.connector.as2.internal.param.MdnHandlerParameters;
import com.mulesoft.connector.as2.internal.stream.InputStreamResource;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.CaseInsensitiveHashMap;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2MDNHandlerOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2MDNHandlerOperation.class);

    @Throws(value={MDNHandlerErrorTypeProvider.class})
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, AS2MdnAttributes> receivedMDN(@ParameterGroup(name="MDN Handler Parameters") MdnHandlerParameters mdnHandlerParameters, @DisplayName(value="Http Headers") MultiMap<String, String> headers, @Content(primary=true) InputStream mdnInputStream) {
        InputStreamResource savedMDNResource = InputStreamResource.saveToResource((InputStream)mdnInputStream);
        CaseInsensitiveHashMap<String, String> httpHeaders = this.getCaseInsensitiveMap(headers);
        MimePart multipartReport = this.getMultipartPart(savedMDNResource, httpHeaders);
        this.verifySignedMessage(httpHeaders, mdnHandlerParameters.getPartnerPemContent(), multipartReport, mdnHandlerParameters.getValidateCertificate());
        MDNReport mdnReport = MDNReport.findMDNReport((MimePart)multipartReport);
        AS2MdnAttributesBuilder as2MdnAttributes = this.buildAs2MdnAttributes(mdnHandlerParameters.getFromName(), mdnHandlerParameters.getToName(), httpHeaders);
        if (mdnReport == null) {
            throw new AS2ExtensionException("The mdn block was not found", AS2ErrorType.MIME_PARSE);
        }
        com.mulesoft.connector.as2.internal.enums.HashAlgorithm digestAlgorithm = mdnReport.getDigestAlgorithm();
        HashAlgorithm mdnAlg = null;
        if (digestAlgorithm != null) {
            mdnAlg = HashAlgorithm.findByAlgorithm(digestAlgorithm.algorithm());
        }
        as2MdnAttributes.withOriginalAS2MessageId(mdnReport.getOriginalMessageId()).withMdnProcessed(mdnReport.isProcessed()).withDispositionContent((MultiMap<String, List<String>>)mdnReport.getDispositionNotificationContent()).withMdnAlg(mdnAlg).withReportText(mdnReport.getReportText());
        if (mdnReport.getReceivedContentMic() != null) {
            as2MdnAttributes.withMdnMic(mdnReport.getReceivedContentMic());
        } else {
            LOGGER.debug("No Calculated Digest was found. MDN mic wont be returned.");
        }
        return Result.builder().attributes((Object)as2MdnAttributes.build()).output((Object)savedMDNResource.asInputStream()).build();
    }

    private MimePart getMultipartPart(InputStreamResource savedMDNResource, CaseInsensitiveHashMap<String, String> httpHeaders) {
        MimePart multipartReport;
        try {
            MimeParserController mimeParserController = new MimeParserController(false, true);
            multipartReport = mimeParserController.parse(httpHeaders, savedMDNResource.asInputStream());
        }
        catch (IOException e) {
            throw new AS2ExtensionException("Could not parse the received MDN report", AS2ErrorType.MIME_PARSE, (Throwable)e);
        }
        return multipartReport;
    }

    private CaseInsensitiveHashMap<String, String> getCaseInsensitiveMap(MultiMap headers) {
        CaseInsensitiveHashMap httpHeaders = new CaseInsensitiveHashMap();
        httpHeaders.putAll((Map)headers);
        return httpHeaders;
    }

    private void verifySignedMessage(CaseInsensitiveHashMap<String, String> httpHeaders, String partnerPemContent, MimePart multipartReport, boolean validateCertificate) {
        if (this.isMultipartSigned(httpHeaders)) {
            LOGGER.debug("Retrieving key information from Partner Pem content.");
            AS2PEMParser pemParser = new AS2PEMParser().withPemContent(partnerPemContent).build();
            if (validateCertificate) {
                this.checkCertValidity(pemParser.getCertificateWithExpirationValidation());
            }
            SignedMimeMultipartValidator signedMimeMultipartValidator = new SignedMimeMultipartValidator().withPublicKey(pemParser.getPublicKey());
            MimeValidatorController validatorController = new MimeValidatorController().withValidator((MimePartValidator)signedMimeMultipartValidator);
            validatorController.validate(multipartReport);
        }
    }

    private void checkCertValidity(Certificate cert) {
        try {
            ((ValidCertificate)cert).checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "The Certificate is expired. Signature Validation for the incoming MDN has failed!", AS2ErrorType.CONFIGURATION);
        }
        catch (CertificateNotYetValidException e) {
            throw new AS2ExtensionException(DispositionType.PROCESSED_ERROR_AUTHENTICATION_FAILED, "The Certificate is not valid yet. Signature Validation for the incoming MDN has failed!", AS2ErrorType.CONFIGURATION);
        }
    }

    private boolean isMultipartSigned(CaseInsensitiveHashMap<String, String> httpHeaders) {
        if (httpHeaders.get((Object)"Content-Type") == null) {
            return false;
        }
        return ((String)httpHeaders.get((Object)"Content-Type")).trim().startsWith("multipart/signed");
    }

    private AS2MdnAttributesBuilder buildAs2MdnAttributes(String fromName, String toName, CaseInsensitiveHashMap<String, String> httpHeaders) {
        MultiMap newHttpHeadersMap = new MultiMap();
        httpHeaders.forEach((key, value) -> {
            List<String> list = Collections.singletonList(value);
            newHttpHeadersMap.put(key, list);
        });
        return new AS2MdnAttributesBuilder().withHeaders((MultiMap<String, String>)newHttpHeadersMap).withFromName(fromName).withToName(toName).withAs2MessageId((String)httpHeaders.get((Object)"Message-ID"));
    }
}

