/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.param;

import com.mulesoft.connector.as2.api.CheckForDuplicateMessages;
import com.mulesoft.connector.as2.api.MdnKeyDetail;
import com.mulesoft.connector.as2.api.ReceiveMessageSecurityLevel;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class RequestHandlerParameters {
    @Parameter
    @DisplayName(value="Partner Pem Content")
    @Summary(value="Should include the certs/public key of the partner. This will be used for both signature verification and encryption")
    @Optional
    private String partnerPemContent;
    @Parameter
    @Password
    @DisplayName(value="Self Private Key Password")
    @Summary(value="Private key password in self pem content")
    @Optional
    private String privateKeyPassword;
    @Parameter
    @DisplayName(value="Self Pem Content")
    @Summary(value="Must include any certificates or public key and private key of the organisation. These will both be used for signing and the private key for decryption.")
    @Optional
    private String selfPemContent;
    @Parameter
    @DisplayName(value="Use different Private Key for MDN Signature")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterDsl(allowReferences=false)
    @Summary(value="Allow to use a different private key on KeyStore to use with MDN Signature.")
    private MdnKeyDetail mdnKeyDetail;
    @Parameter
    @DisplayName(value="Validate certificate date")
    @Summary(value="If set to TRUE, it won't be possible to receive or send messages if the certificate is expired. If set to FALSE, the console will only log the expiration date.")
    @Optional(defaultValue="false")
    private boolean validateCertificate;
    @Parameter
    @Optional
    @DisplayName(value="Security Requirement Level")
    @Summary(value="The security level required for any AS2 Listener using this config for all incoming messages. Should the security requirement not be met, an error MDN response shall result.")
    private ReceiveMessageSecurityLevel securityLevel;
    @Parameter
    @DisplayName(value="Include original message id in MDN Subject")
    @Optional(defaultValue="true")
    private boolean includeOriginalMessageId;
    @Parameter
    @DisplayName(value="Include AS2 server names in the MND Message ID")
    @Optional(defaultValue="true")
    private boolean includeAS2ServerNames;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="When enabled, this parameter allows you to check for duplicate messages by 'message identity token', which is generated with the following pattern: `{as2FromName}-{as2ToName}-{as2MessageId}`.")
    @ParameterDsl(allowReferences=false)
    @DisplayName(value="Check for duplicate messages")
    private CheckForDuplicateMessages checkForDuplicateMessages;

    public String getPartnerPemContent() {
        return this.partnerPemContent;
    }

    public String getSelfPemContent() {
        return this.selfPemContent;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public boolean getValidateCertificate() {
        return this.validateCertificate;
    }

    public void setPartnerPemContent(String partnerPemContent) {
        this.partnerPemContent = partnerPemContent;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public void setSelfPemContent(String selfPemContent) {
        this.selfPemContent = selfPemContent;
    }

    public void setValidateCertificate(boolean validateCertificate) {
        this.validateCertificate = validateCertificate;
    }

    public boolean isIncludeOriginalMessageId() {
        return this.includeOriginalMessageId;
    }

    public boolean isIncludeAS2ServerNames() {
        return this.includeAS2ServerNames;
    }

    public CheckForDuplicateMessages getCheckForDuplicateMessages() {
        return this.checkForDuplicateMessages;
    }

    public void setCheckForDuplicateMessages(CheckForDuplicateMessages checkForDuplicateMessages) {
        this.checkForDuplicateMessages = checkForDuplicateMessages;
    }

    public void setPartnerMdnKeyDetail(MdnKeyDetail mdnKeyDetail) {
        this.mdnKeyDetail = mdnKeyDetail;
    }

    public MdnKeyDetail getMdnKeyDetail() {
        return this.mdnKeyDetail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHandlerParameters that = (RequestHandlerParameters)o;
        return Objects.equals(this.partnerPemContent, that.partnerPemContent) && Objects.equals(this.privateKeyPassword, that.privateKeyPassword) && Objects.equals(this.selfPemContent, that.selfPemContent) && Objects.equals(this.checkForDuplicateMessages, that.checkForDuplicateMessages) && Objects.equals(this.mdnKeyDetail, that.mdnKeyDetail) && this.validateCertificate == that.validateCertificate && this.securityLevel == that.securityLevel && this.includeOriginalMessageId == that.includeOriginalMessageId && this.includeAS2ServerNames == that.includeAS2ServerNames;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partnerPemContent, this.privateKeyPassword, this.selfPemContent, this.checkForDuplicateMessages, this.mdnKeyDetail, this.validateCertificate, this.securityLevel, this.includeAS2ServerNames, this.includeOriginalMessageId});
    }

    public ReceiveMessageSecurityLevel getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(ReceiveMessageSecurityLevel securityRequirementLevel) {
        this.securityLevel = securityRequirementLevel;
    }
}

