/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.utils;

import com.mulesoft.connector.as2.internal.crypto.AS2PEMParser;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemParserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PemParserUtil.class);

    public static KeyPairHolder getKeyPairFromPemContent(String pemContent, String privateKeyPassword, boolean validateCertificate) {
        LOGGER.debug("Retrieving key pair information from Pem content.");
        AS2PEMParser pemParser = new AS2PEMParser();
        if (pemContent != null) {
            pemParser.withPemContent(pemContent);
            if (privateKeyPassword != null) {
                pemParser.withPassword(privateKeyPassword);
            }
            pemParser.build();
            return new KeyPairHolder(pemParser.getPrivateKey(), validateCertificate ? pemParser.getCertificateWithExpirationValidation() : pemParser.getCertificate());
        }
        return null;
    }

    public static Certificate getCertificateFromPemContent(String pemContent, boolean validateCertificate) {
        LOGGER.debug("Retrieving Certificate information from Pem content.");
        AS2PEMParser pemParser = new AS2PEMParser();
        if (pemContent != null) {
            pemParser.withPemContent(pemContent);
            pemParser.build();
            return validateCertificate ? pemParser.getCertificateWithExpirationValidation() : pemParser.getCertificate();
        }
        return null;
    }

    public static class KeyPairHolder {
        private PrivateKey privateKey;
        private Certificate certificate;

        public KeyPairHolder(PrivateKey privateKey, Certificate certificate) {
            this.privateKey = privateKey;
            this.certificate = certificate;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public Certificate getCertificate() {
            return this.certificate;
        }
    }
}

