/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.as2.internal.operation;

import com.mulesoft.b2b.sync.DuplicatedKeyCheck;
import com.mulesoft.b2b.sync.SyncSingleton;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import com.mulesoft.connector.as2.api.AS2ReceiveAttributes;
import com.mulesoft.connector.as2.internal.enums.RequiredSecurityLevel;
import com.mulesoft.connector.as2.internal.error.DispositionType;
import com.mulesoft.connector.as2.internal.error.exception.AS2ExtensionException;
import com.mulesoft.connector.as2.internal.error.provider.ReceiveErrorTypeProvider;
import com.mulesoft.connector.as2.internal.mime.MimePart;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MDNBuilder;
import com.mulesoft.connector.as2.internal.mime.builder.AS2MessageIdGeneratorFactory;
import com.mulesoft.connector.as2.internal.mime.builder.BoundaryIdentifierGeneratorFactory;
import com.mulesoft.connector.as2.internal.model.builder.ReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.param.RequestHandlerParameters;
import com.mulesoft.connector.as2.internal.receive.AbstractReceiveAttributesBuilder;
import com.mulesoft.connector.as2.internal.receive.MDN;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandler;
import com.mulesoft.connector.as2.internal.receive.ReceiveHandlerCallback;
import com.mulesoft.connector.as2.internal.receive.RequestKeyStore;
import com.mulesoft.connector.as2.internal.receive.SignedMimeMessageAttributes;
import com.mulesoft.connector.as2.internal.utils.PemParserUtil;
import java.io.InputStream;
import java.security.cert.Certificate;
import javax.inject.Inject;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2RequestHandlerOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2RequestHandlerOperation.class);
    private static final String ID_OBJECT_STORE = "PartnerManagerOperationsConnectorIdentifierObjectStore";
    @Inject
    private ObjectStoreManager objectStoreManager;
    private ObjectStoreWithLockManager keyManager;
    private DuplicatedKeyCheck duplicatedKeyCheck;

    @Throws(value={ReceiveErrorTypeProvider.class})
    @MediaType(value="*/*", strict=false)
    public Result<InputStream, AS2ReceiveAttributes> requestHandler(@ParameterGroup(name="Request Parameters") RequestHandlerParameters parameters, @Content(primary=true) @DisplayName(value="Http Request Content") InputStream requestContent, @DisplayName(value="Http Request Headers") MultiMap<String, String> headers) {
        LOGGER.trace("\nRequest Handler: Self PEM Content:\n" + parameters.getSelfPemContent() + "\nPassword: " + parameters.getPrivateKeyPassword());
        LOGGER.trace("\nRequest Handler: Partner PEM Content:\n" + parameters.getPartnerPemContent());
        LOGGER.trace("\nPrepare SEND: Validate Certificate expiration: " + parameters.getValidateCertificate());
        CaseInsensitiveMultiMap httpHeaders = this.getCaseInsensitiveHttpHeadersMap(headers);
        final ReceiveAttributesBuilder receiveAttributesBuilder = new ReceiveAttributesBuilder();
        RequestKeyStore requestKeyStore = this.getRequestKeyStore(parameters);
        boolean isDuplicatedMessage = false;
        if (parameters.getCheckForDuplicateMessages() != null) {
            this.getDuplicateCheck(parameters);
            String messageId = (String)httpHeaders.get((Object)"message-id");
            String key = String.format("%s-%s-%s", httpHeaders.get((Object)"as2-from"), httpHeaders.get((Object)"as2-to"), messageId);
            if (!this.cacheIdentifier(key)) {
                LOGGER.error(String.format("An AS2 message with the message ID '%s' has been already processed successfully", messageId));
                isDuplicatedMessage = true;
            }
        }
        final Result.Builder resultBuilder = Result.builder();
        ReceiveHandlerCallback receiveHandlerCallback = new ReceiveHandlerCallback(){

            private void notifyResult(InputStream content, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, MimePart mimePart) {
                if (dispositionType != null && dispositionType != DispositionType.PROCESSED && LOGGER.isErrorEnabled()) {
                    LOGGER.error(String.format("Will not execute the rest of the flow as there is an AS2 processing error:\nStatus: %s\nStatus Modifier: %s\nDescription: %s", dispositionType.getStatus(), dispositionType.getStatusModifier(), dispositionType.getStatusDescription()));
                }
                MDN mdn = signedMimeMessageAttributes.getMdn();
                receiveAttributesBuilder.withProcessed(mdn.isProcessed());
                if (mdn.getMdnMimePart() != null) {
                    receiveAttributesBuilder.withMdnResponse(IOUtils.toString((InputStream)mdn.getMdnMimePart().getContent())).withMdnHeaders((MultiMap<String, String>)mdn.getMdnHttpHeaders());
                }
                resultBuilder.attributes((Object)receiveAttributesBuilder.build()).output((Object)content);
            }

            public void notifyError(Throwable e, MimePart mimePart) {
                if (e instanceof AS2ExtensionException) {
                    throw (AS2ExtensionException)e;
                }
                throw new AS2ExtensionException("Unexpected error receiving AS2 message", e);
            }

            public void notifySyncMDNResult(InputStream inputStream, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, MimePart mimePart, AS2MDNBuilder as2MDNBuilder) {
                MDN mdn = as2MDNBuilder.build();
                signedMimeMessageAttributes.setMdn(mdn);
                this.notifyResult(inputStream, signedMimeMessageAttributes, dispositionType, mimePart);
            }

            public void notifyAsyncMDNResult(InputStream inputStream, SignedMimeMessageAttributes signedMimeMessageAttributes, DispositionType dispositionType, MimePart mimePart, AS2MDNBuilder as2MDNBuilder) {
                MDN mdn = as2MDNBuilder.build();
                signedMimeMessageAttributes.setMdn(mdn);
                this.notifyResult(inputStream, signedMimeMessageAttributes, dispositionType, mimePart);
            }

            public void notifyNoMDNResult(InputStream inputStream, SignedMimeMessageAttributes signedMimeMessageAttributes, MimePart mimePart, AS2MDNBuilder as2MDNBuilder) {
                MDN mdn = as2MDNBuilder.buildEmpty();
                signedMimeMessageAttributes.setMdn(mdn);
                this.notifyResult(inputStream, signedMimeMessageAttributes, DispositionType.PROCESSED, mimePart);
            }

            public void notifyReadyForOkHttpResponse() {
            }

            public void notifyException(AS2ExtensionException exception) {
                super.notifyException(exception);
                throw exception;
            }
        };
        RequiredSecurityLevel securityLevel = this.getRequiredSecurityLevel(parameters);
        this.createReceiveHandler(httpHeaders, parameters.isIncludeAS2ServerNames(), parameters.isIncludeOriginalMessageId()).receiveAS2Message(httpHeaders, requestContent, (AbstractReceiveAttributesBuilder)receiveAttributesBuilder, requestKeyStore, receiveHandlerCallback, false, securityLevel, isDuplicatedMessage);
        return resultBuilder.build();
    }

    private synchronized DuplicatedKeyCheck getDuplicateCheck(RequestHandlerParameters parameters) {
        if (parameters.getCheckForDuplicateMessages() != null) {
            SyncSingleton syncSingleton = SyncSingleton.getInstance((String)ID_OBJECT_STORE, (ObjectStore)parameters.getCheckForDuplicateMessages().getObjectStore());
            this.duplicatedKeyCheck = syncSingleton.getDuplicatedKeyCheck();
        }
        return this.duplicatedKeyCheck;
    }

    private boolean cacheIdentifier(String ident) {
        return this.duplicatedKeyCheck.keyNotDuplicated("AS2", ident);
    }

    private RequiredSecurityLevel getRequiredSecurityLevel(RequestHandlerParameters parameters) {
        RequiredSecurityLevel securityLevel = null;
        if (parameters.getSecurityLevel() != null) {
            securityLevel = RequiredSecurityLevel.findRequiredSecurityLevel((String)parameters.getSecurityLevel().name());
        }
        return securityLevel;
    }

    RequestKeyStore getRequestKeyStore(RequestHandlerParameters parameters) {
        RequestKeyStore requestKeyStore = new RequestKeyStore();
        PemParserUtil.KeyPairHolder selfKeyPairHolder = PemParserUtil.getKeyPairFromPemContent(parameters.getSelfPemContent(), parameters.getPrivateKeyPassword(), parameters.getValidateCertificate());
        requestKeyStore.setSelfCertificate(selfKeyPairHolder.getCertificate());
        requestKeyStore.setSelfPrivateKey(selfKeyPairHolder.getPrivateKey());
        Certificate partnerCertificate = PemParserUtil.getCertificateFromPemContent(parameters.getPartnerPemContent(), parameters.getValidateCertificate());
        requestKeyStore.setPartnerCertificate(partnerCertificate);
        PemParserUtil.KeyPairHolder mdnSelfKeyPairHolder = parameters.getMdnKeyDetail() != null ? PemParserUtil.getKeyPairFromPemContent(parameters.getMdnKeyDetail().getMdnPemContent(), parameters.getMdnKeyDetail().getMdnPrivateKeyPassword(), parameters.getValidateCertificate()) : PemParserUtil.getKeyPairFromPemContent(parameters.getSelfPemContent(), parameters.getPrivateKeyPassword(), parameters.getValidateCertificate());
        requestKeyStore.setSelfCertificateForMDN(mdnSelfKeyPairHolder.getCertificate());
        requestKeyStore.setSelfPrivateKeyForMDN(mdnSelfKeyPairHolder.getPrivateKey());
        return requestKeyStore;
    }

    private CaseInsensitiveMultiMap getCaseInsensitiveHttpHeadersMap(MultiMap headers) {
        CaseInsensitiveMultiMap httpHeaders = new CaseInsensitiveMultiMap();
        httpHeaders.putAll(headers);
        return httpHeaders;
    }

    private ReceiveHandler createReceiveHandler(CaseInsensitiveMultiMap httpHeaders, boolean isIncludeAS2ServerNames, boolean isIncludeOriginalMessageId) {
        return new ReceiveHandler.ReceiveHandlerFactory().createReceiveHandler(httpHeaders, isIncludeAS2ServerNames, isIncludeOriginalMessageId).withBoundaryIdentifierGeneratorFactory(new BoundaryIdentifierGeneratorFactory()).withAS2MessageIdGeneratorFactory(new AS2MessageIdGeneratorFactory());
    }
}

