/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.lib.keyvault.client;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.security.keyvault.keys.KeyClient;
import com.azure.security.keyvault.keys.KeyClientBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.mulesoft.connector.lib.keyvault.api.TokenCredentialProperties;
import com.mulesoft.connector.lib.keyvault.client.KeyVaultClient;
import com.mulesoft.connector.lib.keyvault.client.KeyVaultClientFactory;
import com.mulesoft.connector.lib.keyvault.client.KeyVaultClientImpl;
import com.mulesoft.connector.lib.keyvault.crypto.CryptoClientFactory;

public class KeyVaultClientFactoryImpl
implements KeyVaultClientFactory {
    private TokenCredential tokenCredential;

    private KeyClient getKeyClient(String uri) {
        return new KeyClientBuilder().vaultUrl(uri).credential(this.tokenCredential).buildClient();
    }

    private SecretClient getSecretClient(String uri) {
        return new SecretClientBuilder().vaultUrl(uri).credential(this.tokenCredential).buildClient();
    }

    private CertificateClient getCertificateClient(String uri) {
        return new CertificateClientBuilder().vaultUrl(uri).credential(this.tokenCredential).buildClient();
    }

    private TokenCredential getTokenCredential(TokenCredentialProperties properties) {
        return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(properties.getClientId())).tenantId(properties.getTenantId())).clientSecret(properties.getClientSecret()).build();
    }

    @Override
    public KeyVaultClient createCachedConnection(TokenCredentialProperties properties, long ttl) {
        this.tokenCredential = this.getTokenCredential(properties);
        KeyClient keyClient = this.getKeyClient(properties.getUri());
        return new KeyVaultClientImpl(this.getSecretClient(properties.getUri()), this.getCertificateClient(properties.getUri()), new CryptoClientFactory().createCachedProvider(properties, keyClient, ttl));
    }

    @Override
    public KeyVaultClient createConnection(TokenCredentialProperties properties) {
        this.tokenCredential = this.getTokenCredential(properties);
        KeyClient keyClient = this.getKeyClient(properties.getUri());
        return new KeyVaultClientImpl(this.getSecretClient(properties.getUri()), this.getCertificateClient(properties.getUri()), new CryptoClientFactory().createNonCachedProvider(properties, keyClient));
    }
}

