/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.lib.keyvault.client;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.models.CertificatePolicy;
import com.azure.security.keyvault.certificates.models.CertificateProperties;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificate;
import com.azure.security.keyvault.certificates.models.KeyVaultCertificateWithPolicy;
import com.azure.security.keyvault.keys.cryptography.models.DecryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptResult;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import com.azure.security.keyvault.keys.implementation.models.KeyVaultErrorException;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.mulesoft.connector.lib.keyvault.api.CryptographyResult;
import com.mulesoft.connector.lib.keyvault.api.VaultCertificate;
import com.mulesoft.connector.lib.keyvault.api.VaultEncryptionAlgorithm;
import com.mulesoft.connector.lib.keyvault.api.VaultSecret;
import com.mulesoft.connector.lib.keyvault.client.KeyVaultClient;
import com.mulesoft.connector.lib.keyvault.crypto.CryptoClientProvider;
import com.mulesoft.connector.lib.keyvault.error.AuthenticationException;
import com.mulesoft.connector.lib.keyvault.error.CertificateNotFoundException;
import com.mulesoft.connector.lib.keyvault.error.DecryptException;
import com.mulesoft.connector.lib.keyvault.error.EncryptException;
import com.mulesoft.connector.lib.keyvault.error.InvalidHostException;
import com.mulesoft.connector.lib.keyvault.error.SecretNotFoundException;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyVaultClientImpl
implements KeyVaultClient {
    private static final Logger logger = LoggerFactory.getLogger(KeyVaultClientImpl.class);
    private final SecretClient secretClient;
    private final CertificateClient certificateClient;
    private final CryptoClientProvider cryptoClientProvider;

    public KeyVaultClientImpl(SecretClient secretClient, CertificateClient certificateClient, CryptoClientProvider cryptoClientProvider) {
        this.secretClient = secretClient;
        this.certificateClient = certificateClient;
        this.cryptoClientProvider = cryptoClientProvider;
    }

    @Override
    public VaultSecret getSecret(String name, String version) {
        KeyVaultSecret secret;
        try {
            secret = version == null ? this.secretClient.getSecret(name) : this.secretClient.getSecret(name, version);
        }
        catch (ResourceNotFoundException e) {
            if (e.getMessage().contains("VaultNotFound")) {
                throw new InvalidHostException(this.secretClient.getVaultUrl(), e);
            }
            throw new SecretNotFoundException(name, e);
        }
        catch (ClientAuthenticationException | MsalServiceException e) {
            throw new AuthenticationException(e);
        }
        catch (HttpResponseException e) {
            String message = e.getMessage();
            if (message.contains("The request URI contains an invalid name") || message.contains("Method GET does not allow operation '" + version) || message.contains("Bad Request")) {
                throw new SecretNotFoundException(name, version, e);
            }
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new InvalidHostException(this.secretClient.getVaultUrl(), e);
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof MsalServiceException) {
                throw new AuthenticationException(e.getCause().getCause());
            }
            throw e;
        }
        SecretProperties properties = secret.getProperties();
        return new VaultSecret(secret.getValue(), secret.getId(), properties.getVersion(), properties.isEnabled(), properties.getNotBefore(), properties.getExpiresOn(), properties.getCreatedOn(), properties.getUpdatedOn(), secret.getName(), properties.getRecoveryLevel(), properties.getContentType());
    }

    @Override
    public VaultSecret getSecret(String name) {
        return this.getSecret(name, null);
    }

    @Override
    public CryptographyResult encryptMessage(String keyName, VaultEncryptionAlgorithm algorithm, byte[] toEncrypt) {
        return this.encryptMessage(keyName, algorithm, toEncrypt, null);
    }

    @Override
    public CryptographyResult encryptMessage(String keyName, VaultEncryptionAlgorithm algorithm, byte[] toEncrypt, String keyVersion) {
        EncryptResult encryptionResult;
        try {
            encryptionResult = this.cryptoClientProvider.getCryptoClient(keyName, keyVersion).encrypt(EncryptionAlgorithm.fromString((String)algorithm.getName()), toEncrypt);
        }
        catch (ResourceModifiedException e) {
            throw new EncryptException(keyName, keyVersion, algorithm, e);
        }
        catch (UnsupportedOperationException e) {
            throw new EncryptException(e.getMessage(), e);
        }
        return new CryptographyResult(encryptionResult.getCipherText(), keyName, algorithm);
    }

    @Override
    public CryptographyResult decryptMessage(String keyName, VaultEncryptionAlgorithm algorithm, byte[] encrypted) {
        return this.decryptMessage(keyName, algorithm, encrypted, null);
    }

    @Override
    public CryptographyResult decryptMessage(String keyName, VaultEncryptionAlgorithm algorithm, byte[] encrypted, String keyVersion) {
        return this.decryptMessage(keyName, algorithm, encrypted, keyVersion, true);
    }

    private CryptographyResult decryptMessage(String keyName, VaultEncryptionAlgorithm algorithm, byte[] encrypted, String keyVersion, boolean retry) {
        DecryptResult decryptionResult;
        try {
            decryptionResult = this.cryptoClientProvider.getCryptoClient(keyName, keyVersion).decrypt(EncryptionAlgorithm.fromString((String)algorithm.getName()), encrypted);
        }
        catch (ResourceModifiedException e) {
            logger.warn("Decrypting failed, reattempting with newest version of key");
            if (retry) {
                return this.decryptMessage(keyName, algorithm, encrypted, keyVersion, false);
            }
            throw new DecryptException(keyName, keyVersion, algorithm, e);
        }
        catch (UnsupportedOperationException e) {
            throw new DecryptException(e.getMessage(), e);
        }
        catch (KeyVaultErrorException e) {
            throw new DecryptException(keyName, keyVersion, algorithm, e);
        }
        return new CryptographyResult(decryptionResult.getPlainText(), keyName, algorithm);
    }

    @Override
    public boolean testConnection() {
        try {
            this.secretClient.listPropertiesOfSecrets().iterator().hasNext();
        }
        catch (MsalServiceException e) {
            throw new AuthenticationException(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new InvalidHostException(this.secretClient.getVaultUrl(), e);
            }
            if (e.getCause() instanceof ExecutionException && e.getCause().getCause() instanceof MsalServiceException) {
                throw new AuthenticationException(e);
            }
            throw e;
        }
        return true;
    }

    @Override
    public VaultCertificate getCertificate(String certificateName) {
        KeyVaultCertificateWithPolicy cert;
        try {
            cert = this.certificateClient.getCertificate(certificateName);
        }
        catch (ResourceNotFoundException e) {
            if (e.getMessage().contains("VaultNotFound")) {
                throw new InvalidHostException(this.secretClient.getVaultUrl(), e);
            }
            throw new CertificateNotFoundException(certificateName, e);
        }
        catch (HttpResponseException e) {
            String message = e.getMessage();
            if (message.contains("The request URI contains an invalid name")) {
                throw new CertificateNotFoundException(certificateName, e);
            }
            throw e;
        }
        catch (MsalServiceException e) {
            throw new AuthenticationException(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new InvalidHostException(this.certificateClient.getVaultUrl(), e);
            }
            throw e;
        }
        CertificateProperties properties = cert.getProperties();
        CertificatePolicy policy = cert.getPolicy();
        return new VaultCertificate(cert.getCer(), cert.getKeyId(), cert.getSecretId(), properties.isEnabled(), properties.getNotBefore(), properties.getExpiresOn(), properties.getCreatedOn(), properties.getUpdatedOn(), properties.getRecoveryLevel(), properties.getVersion(), properties.getName(), properties.getId(), this.getSecret(properties.getName(), properties.getVersion()), policy.getContentType().toString(), policy.getCertificateType(), policy.getKeyType().toString());
    }

    @Override
    public VaultCertificate getCertificate(String certificateName, String version) {
        KeyVaultCertificate cert;
        try {
            cert = this.certificateClient.getCertificateVersion(certificateName, version);
        }
        catch (ResourceNotFoundException e) {
            if (e.getMessage().contains("VaultNotFound")) {
                throw new InvalidHostException(this.secretClient.getVaultUrl(), e);
            }
            throw new CertificateNotFoundException(certificateName, e);
        }
        catch (HttpResponseException e) {
            String message = e.getMessage();
            if (message.contains("The request URI contains an invalid name") || message.contains("Method GET does not allow operation '" + version)) {
                throw new CertificateNotFoundException(certificateName, version, e);
            }
            throw e;
        }
        catch (MsalServiceException e) {
            throw new AuthenticationException(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownHostException) {
                throw new InvalidHostException(this.certificateClient.getVaultUrl(), e);
            }
            throw e;
        }
        CertificateProperties properties = cert.getProperties();
        return new VaultCertificate(cert.getCer(), cert.getKeyId(), cert.getSecretId(), properties.isEnabled(), properties.getNotBefore(), properties.getExpiresOn(), properties.getCreatedOn(), properties.getUpdatedOn(), properties.getRecoveryLevel(), properties.getVersion(), properties.getName(), properties.getId());
    }
}

