/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.lib.keyvault.crypto;

import com.azure.security.keyvault.keys.cryptography.CryptographyClient;
import com.mulesoft.connector.lib.keyvault.crypto.CryptoClientProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class CachedCryptographyClientProvider
implements CryptoClientProvider {
    private final Map<String, CryptoClient> cachedCryptographyClients;
    private final CryptoClientProvider cryptoClientFactory;
    private final long ttl;

    public CachedCryptographyClientProvider(CryptoClientProvider cryptoClientFactory, long ttl) {
        this.ttl = ttl;
        this.cachedCryptographyClients = new ConcurrentHashMap<String, CryptoClient>();
        this.cryptoClientFactory = cryptoClientFactory;
    }

    @Override
    public CryptographyClient getCryptoClient(String keyName, String version) {
        String dictKey;
        String string = dictKey = version == null ? keyName : keyName + version;
        if (this.cachedCryptographyClients.containsKey(dictKey)) {
            return this.cachedCryptographyClients.get(dictKey).getClient();
        }
        return this.getNewCryptoClient(keyName, version);
    }

    @Override
    public CryptographyClient getNewCryptoClient(String keyName, String version) {
        String dictKey = version == null ? keyName : keyName + version;
        CryptoClient client = version == null ? new TimedOutClient(this.cryptoClientFactory, keyName) : new CryptoClient(this.cryptoClientFactory, keyName, version);
        this.cachedCryptographyClients.put(dictKey, client);
        return client.getClient();
    }

    private class TimedOutClient
    extends CryptoClient {
        long createdOn;

        TimedOutClient(CryptoClientProvider cryptoClientFactory, String keyName) {
            super(cryptoClientFactory, keyName, null);
            this.createdOn = System.currentTimeMillis();
        }

        @Override
        CryptographyClient getClient() {
            long actualTime = System.currentTimeMillis();
            if (actualTime - this.createdOn > CachedCryptographyClientProvider.this.ttl) {
                this.createdOn = System.currentTimeMillis();
                this.client = this.cryptoClientFactory.getCryptoClient(this.keyName, null);
                return this.client;
            }
            return this.client;
        }
    }

    private static class CryptoClient {
        protected CryptographyClient client;
        protected final String keyName;
        protected final CryptoClientProvider cryptoClientFactory;

        CryptoClient(CryptoClientProvider cryptoClientProvider, String keyName, String version) {
            this.cryptoClientFactory = cryptoClientProvider;
            this.keyName = keyName;
            this.client = cryptoClientProvider.getCryptoClient(keyName, version);
        }

        CryptographyClient getClient() {
            return this.client;
        }
    }
}

