/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.lib.keyvault.api;

import com.mulesoft.connector.lib.keyvault.api.CommonProperties;
import com.mulesoft.connector.lib.keyvault.api.VaultSecret;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;

public class VaultCertificate
extends CommonProperties {
    private final byte[] cert;
    private VaultSecret certificateSecret;
    private final String keyId;
    private final String secretId;
    private final String certificateContentType;
    private final String certificateType;
    private final String certificateKeyType;

    public VaultCertificate(byte[] cert, String keyId, String secretId, boolean enabled, OffsetDateTime notBefore, OffsetDateTime expiresOn, OffsetDateTime createdOn, OffsetDateTime updatedOn, String recoveryLevel, String version, String name, String id, VaultSecret certificateSecret, String certificateContentType, String certificateType, String certificateKeyType) {
        super(enabled, notBefore, expiresOn, createdOn, updatedOn, recoveryLevel, version, name, id);
        this.cert = cert;
        this.keyId = keyId;
        this.secretId = secretId;
        this.certificateSecret = certificateSecret;
        this.certificateContentType = certificateContentType;
        this.certificateType = certificateType;
        this.certificateKeyType = certificateKeyType;
    }

    public VaultCertificate(byte[] cert, String keyId, String secretId, Boolean enabled, OffsetDateTime notBefore, OffsetDateTime expiresOn, OffsetDateTime createdOn, OffsetDateTime updatedOn, String recoveryLevel, String version, String name, String id) {
        this(cert, keyId, secretId, enabled, notBefore, expiresOn, createdOn, updatedOn, recoveryLevel, version, name, id, null, null, null, null);
    }

    public byte[] getCertificate() {
        return this.cert;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public VaultSecret getCertificateSecret() {
        return this.certificateSecret;
    }

    public String getCertificateKeyType() {
        return this.certificateKeyType;
    }

    public String getCertificateContentType() {
        return this.certificateContentType;
    }

    public String getCertificateType() {
        return this.certificateType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultCertificate that = (VaultCertificate)o;
        return Arrays.equals(this.cert, that.cert) && Objects.equals(this.certificateSecret, that.certificateSecret) && Objects.equals(this.keyId, that.keyId) && Objects.equals(this.secretId, that.secretId) && Objects.equals(this.certificateContentType, that.certificateContentType) && Objects.equals(this.certificateType, that.certificateType) && Objects.equals(this.certificateKeyType, that.certificateKeyType);
    }

    public int hashCode() {
        int result = Objects.hash(this.certificateSecret, this.keyId, this.secretId, this.certificateContentType, this.certificateType, this.certificateKeyType);
        result = 31 * result + Arrays.hashCode(this.cert);
        return result;
    }
}

