/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubConnectivityException;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubError;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubException;
import com.mulesoft.connectors.cloudhub.internal.value.provider.AnypointPlatformUrlProvider;
import com.mulesoft.connectors.cloudhub.internal.value.provider.EnvironmentsValueProvider;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudHubConnectionProvider
implements CachedConnectionProvider<CloudHubConnection> {
    private final Logger LOGGER = LoggerFactory.getLogger(CloudHubConnectionProvider.class);
    @Parameter
    private String username;
    @Parameter
    @Password
    private String password;
    @Parameter
    @Optional
    @OfValues(value=EnvironmentsValueProvider.class)
    private String environment;
    @Parameter
    @Optional(defaultValue="https://anypoint.mulesoft.com")
    @Placement(tab="Advanced")
    @OfValues(value=AnypointPlatformUrlProvider.class)
    @DisplayName(value="Anypoint Platform URL")
    private String anypointPlatformUrl;
    @Inject
    HttpService httpService;

    public CloudHubConnection connect() {
        return new CloudHubConnection(this.username, this.password, this.environment, this.anypointPlatformUrl, this.httpService);
    }

    public void disconnect(CloudHubConnection connection) {
        connection.stop();
    }

    public ConnectionValidationResult validate(CloudHubConnection connection) {
        try {
            HttpResponse httpResponse = connection.users.current.permissions.getPermissions().get();
            int statusCode = httpResponse.getStatusCode();
            if (statusCode > 299) {
                String response = this.getResponseBody(httpResponse);
                switch (statusCode) {
                    case 401: 
                    case 403: {
                        return ConnectionValidationResult.failure((String)("Invalid Credentials. Original Message: " + response), (Exception)((Object)new CloudHubException("Invalid Credentials", CloudHubError.INVALID_CREDENTIALS)));
                    }
                }
                return ConnectionValidationResult.failure((String)("Unknown Error occurred tyring to validate the connection. Original Message: " + response), (Exception)((Object)new CloudHubConnectivityException("Unknown Error occurred tyring to validate the connection")));
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            return ConnectionValidationResult.failure((String)"Unexpected Error occurred trying to validate the connection.", (Exception)((Object)new CloudHubConnectivityException(e.getMessage(), e)));
        }
        return ConnectionValidationResult.success();
    }

    private String getResponseBody(HttpResponse response) throws IOException {
        return new String(response.getEntity().getBytes());
    }
}

