/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal;

import com.google.gson.Gson;
import com.mulesoft.connectors.cloudhub.api.MarkStatus;
import com.mulesoft.connectors.cloudhub.api.NotificationStatus;
import com.mulesoft.connectors.cloudhub.api.Priority;
import com.mulesoft.connectors.cloudhub.internal.NotificationFilterConfiguration;
import com.mulesoft.connectors.cloudhub.internal.OperationUtils;
import com.mulesoft.connectors.cloudhub.internal.StatisticsInformation;
import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubErrorProvider;
import com.mulesoft.connectors.cloudhub.internal.metadata.GetApplicationOutputResolver;
import com.mulesoft.connectors.cloudhub.internal.metadata.GetApplicationsOutputResolver;
import com.mulesoft.connectors.cloudhub.internal.metadata.NotificationResolver;
import com.mulesoft.connectors.cloudhub.internal.model.Notification;
import com.mulesoft.connectors.cloudhub.internal.value.provider.DomainsValueProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

@Throws(value={CloudHubErrorProvider.class})
public class CloudHubOperations {
    @Inject
    ExpressionManager expressionManager;

    @DisplayName(value="List Applications")
    @MediaType(value="application/json")
    @OutputResolver(output=GetApplicationsOutputResolver.class)
    public void listApplications(@Connection CloudHubConnection cloudHubConnection, @ParameterGroup(name="Statistics Information") StatisticsInformation statisticsInformation, @DisplayName(value="Retrieve Log Levels") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true") boolean retrieveLogLevels, @DisplayName(value="Retrieve Tracking Settings") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true") boolean retrieveTrackingSettings, @DisplayName(value="Retrieve IP Addresses") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true") boolean retrieveIpAddresses, CompletionCallback<InputStream, Void> competitionCallback) {
        cloudHubConnection.v2.applications.get(statisticsInformation.isRetrieveStatistics(), String.valueOf(statisticsInformation.getPeriodTimeUnit().toMillis(statisticsInformation.getPeriod())), retrieveLogLevels, retrieveTrackingSettings, retrieveIpAddresses).whenCompleteAsync((BiConsumer)OperationUtils.createCompletionHandler(competitionCallback));
    }

    @DisplayName(value="Get Application")
    @MediaType(value="application/json")
    @OutputResolver(output=GetApplicationOutputResolver.class)
    public void getApplication(@Connection CloudHubConnection cloudHubConnection, @OfValues(value=DomainsValueProvider.class) String domain, CompletionCallback<InputStream, Void> competitionCallback) {
        cloudHubConnection.v2.applications.getApplication(domain).whenCompleteAsync((BiConsumer)OperationUtils.createCompletionHandler(competitionCallback));
    }

    @DisplayName(value="Create Notification")
    public void createNotification(@Connection CloudHubConnection connection, @OfValues(value=DomainsValueProvider.class) String domain, @Content(primary=true) String message, @NullSafe @org.mule.runtime.extension.api.annotation.param.Optional @Content Map<String, String> customProperties, @org.mule.runtime.extension.api.annotation.param.Optional Priority priority, @org.mule.runtime.extension.api.annotation.param.Optional String transactionId, CompletionCallback<Void, Void> completionCallback) {
        String notification = new Gson().toJson((Object)new Notification(domain, transactionId, message, customProperties, priority));
        connection.notifications.post(new ByteArrayInputStream(notification.getBytes())).whenCompleteAsync((BiConsumer)OperationUtils.createCompletionHandler(completionCallback));
    }

    @DisplayName(value="List Notifications")
    @MediaType(value="application/java")
    @OutputResolver(output=NotificationResolver.class)
    public PagingProvider<CloudHubConnection, Map<String, Object>> listNotifications(final @OfValues(value=DomainsValueProvider.class) String domain, final @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="-1") int limit, final @Placement(tab="Advanced") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="25") int pageSize, final @ParameterGroup(name="Notification Filter") NotificationFilterConfiguration filterConfiguration) {
        return new PagingProvider<CloudHubConnection, Map<String, Object>>(){
            int currentOffset = 0;

            public List<Map<String, Object>> getPage(CloudHubConnection connection) {
                final CountDownLatch resolutionLatch = new CountDownLatch(1);
                final Reference result = new Reference();
                final Reference error = new Reference();
                CompletionCallback<List<Map<String, Object>>, Void> completionCallback = new CompletionCallback<List<Map<String, Object>>, Void>(){

                    public void success(Result<List<Map<String, Object>>, Void> notificationResult) {
                        try {
                            result.set(notificationResult.getOutput());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            resolutionLatch.countDown();
                        }
                    }

                    public void error(Throwable e) {
                        error.set((Object)e);
                        resolutionLatch.countDown();
                    }
                };
                int notificationsToGather = this.getNotificationsToGather();
                if (notificationsToGather <= 0) {
                    return Collections.emptyList();
                }
                connection.notifications.get(domain, notificationsToGather, this.currentOffset, CloudHubOperations.this.toQueryParams(filterConfiguration.getStatus()), filterConfiguration.getSearch()).whenCompleteAsync((BiConsumer)OperationUtils.createCompletionHandler((CompletionCallback)completionCallback, "#[output application/java --- payload.data]", CloudHubOperations.this.expressionManager));
                try {
                    resolutionLatch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (error.get() != null) {
                    Throwable throwable = (Throwable)error.get();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                List maps = (List)result.get();
                this.currentOffset += maps.size();
                return maps;
            }

            public Optional<Integer> getTotalResults(CloudHubConnection connection) {
                return Optional.empty();
            }

            public void close(CloudHubConnection connection) throws MuleException {
            }

            private int getNotificationsToGather() {
                int missingNotifications;
                int notificationsToGather = limit < 0 ? 25 : ((missingNotifications = limit - this.currentOffset) <= pageSize ? missingNotifications : pageSize);
                return notificationsToGather;
            }
        };
    }

    public void markNotification(@Connection CloudHubConnection cloudHubConnection, String notificationId, MarkStatus markAs, CompletionCallback<Void, Void> completionCallback) {
        cloudHubConnection.notifications.put(notificationId, markAs.toString()).whenCompleteAsync((BiConsumer)OperationUtils.createCompletionHandler(completionCallback));
    }

    private String toQueryParams(NotificationStatus status) {
        if (status.equals((Object)NotificationStatus.ALL)) {
            return null;
        }
        return status.toString();
    }

    @Ignore
    public void getAccount(@Connection CloudHubConnection cloudHubConnection, CompletionCallback<InputStream, Void> competitionCallback) {
        cloudHubConnection.account.get().whenCompleteAsync((BiConsumer)OperationUtils.createCompletionHandler(competitionCallback));
    }
}

