/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal;

import com.mulesoft.connectors.cloudhub.internal.error.CloudHubError;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class OperationUtils {
    private OperationUtils() {
    }

    static BiConsumer<HttpResponse, Throwable> createCompletionHandler(CompletionCallback<InputStream, Void> competitionCallback) {
        return OperationUtils.createCompletionHandler(competitionCallback, null, null);
    }

    public static BiConsumer<HttpResponse, Throwable> createCompletionHandler(CompletionCallback competitionCallback, String payloadExpression, ExpressionManager expressionManager) {
        return (httpResponse, e) -> {
            if (e != null || httpResponse.getStatusCode() >= 300) {
                OperationUtils.validateHttpResponse(competitionCallback, httpResponse, e);
            } else if (payloadExpression == null) {
                competitionCallback.success(Result.builder().output((Object)httpResponse.getEntity().getContent()).mediaType(MediaType.APPLICATION_JSON).build());
            } else {
                InputStream content = httpResponse.getEntity().getContent();
                competitionCallback.success(Result.builder().output(expressionManager.evaluate(payloadExpression, OperationUtils.createBinding(content)).getValue()).mediaType(MediaType.APPLICATION_JSON).build());
            }
        };
    }

    private static void validateHttpResponse(CompletionCallback<?, ?> competitionCallback, HttpResponse response, Throwable throwable) {
        if (throwable != null) {
            competitionCallback.error((Throwable)new RuntimeException("Unexpected Error Occurred", throwable));
        } else {
            String responseMessage;
            try {
                responseMessage = new String(response.getEntity().getBytes());
            }
            catch (IOException e) {
                competitionCallback.error((Throwable)new RuntimeException("Unexpected Error Occurred", e));
                return;
            }
            switch (response.getStatusCode()) {
                case 401: 
                case 403: {
                    competitionCallback.error((Throwable)((Object)new CloudHubException("Invalid Credentials. Original Message: " + responseMessage, response.getStatusCode(), CloudHubError.INVALID_CREDENTIALS, new ConnectionException("Invalid Credentials"))));
                    break;
                }
                default: {
                    competitionCallback.error((Throwable)((Object)new CloudHubException("Unknown Error. Original Message: " + responseMessage, response.getStatusCode(), CloudHubError.EXECUTION)));
                }
            }
        }
    }

    private static BindingContext createBinding(InputStream content) {
        return BindingContext.builder().addBinding("payload", new TypedValue((Object)content, DataType.JSON_STRING)).build();
    }
}

