/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection;

import com.mulesoft.connectors.cloudhub.internal.connection.v1.Account;
import com.mulesoft.connectors.cloudhub.internal.connection.v1.Application;
import com.mulesoft.connectors.cloudhub.internal.connection.v1.Applications;
import com.mulesoft.connectors.cloudhub.internal.connection.v1.Notifications;
import com.mulesoft.connectors.cloudhub.internal.connection.v1.Users;
import com.mulesoft.connectors.cloudhub.internal.connection.v2.V2;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public final class CloudHubConnection {
    private final String username;
    private final String password;
    private final String defaultEnviroment;
    private String anypointPlatformUrl;
    private final HttpClient httpClient;
    public final V2 v2;
    public final Account account;
    public final Applications applications;
    public final Users users;
    public final Notifications notifications;

    public CloudHubConnection(String username, String password, String defaultEnviroment, String anypointPlatformUrl, HttpService httpService) {
        this.username = username;
        this.password = password;
        this.defaultEnviroment = defaultEnviroment;
        this.anypointPlatformUrl = anypointPlatformUrl;
        this.httpClient = this.createClient(httpService);
        this.v2 = new V2(this);
        this.account = new Account(this);
        this.applications = new Applications(this);
        this.users = new Users(this);
        this.notifications = new Notifications(this);
    }

    public Application application(String domain) {
        return new Application(this, domain);
    }

    private HttpClient createClient(HttpService httpService) {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder();
        builder.setName("cloudhub-connector");
        HttpClient httpClient = httpService.getClientFactory().create(builder.build());
        httpClient.start();
        return httpClient;
    }

    public CompletableFuture<HttpResponse> sendRequest(String endpoint, HttpConstants.Method method) {
        return this.sendRequest(null, endpoint, method);
    }

    public CompletableFuture<HttpResponse> sendRequest(Consumer<HttpRequestBuilder> httpRequestBuilderConsumer, String endpoint, HttpConstants.Method method) {
        HttpRequestBuilder builder = HttpRequest.builder();
        if (httpRequestBuilderConsumer != null) {
            httpRequestBuilderConsumer.accept(builder);
        }
        builder.method(method);
        if (this.defaultEnviroment != null) {
            builder.addHeader("X-ANYPNT-ENV-ID", this.defaultEnviroment);
        }
        builder.uri(this.anypointPlatformUrl + "/cloudhub/api" + endpoint);
        return this.httpClient.sendAsync(builder.build(), 0, false, HttpAuthentication.basic((String)this.username, (String)this.password).build());
    }

    public void stop() {
        this.httpClient.stop();
    }
}

