/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection.v1;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class Notifications {
    private CloudHubConnection cloudHubConnection;

    public Notifications(CloudHubConnection cloudHubConnection) {
        this.cloudHubConnection = cloudHubConnection;
    }

    public CompletableFuture<HttpResponse> get(String domain, int limit, int offset, String status, String search) {
        return this.cloudHubConnection.sendRequest(requestBuilder -> {
            requestBuilder.addQueryParam("domain", domain);
            requestBuilder.addQueryParam("limit", String.valueOf(limit));
            requestBuilder.addQueryParam("offset", String.valueOf(offset));
            if (status != null) {
                requestBuilder.addQueryParam("status", status);
            }
            if (search != null) {
                requestBuilder.addQueryParam("search", search);
            }
        }, "/notifications", HttpConstants.Method.GET);
    }

    public CompletableFuture<HttpResponse> post(InputStream notification) {
        return this.cloudHubConnection.sendRequest(requestBuilder -> {
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.entity((HttpEntity)new InputStreamHttpEntity(notification));
        }, "/notifications", HttpConstants.Method.POST);
    }

    public CompletableFuture<HttpResponse> put(String notificationId, String notificationStatus) {
        return this.cloudHubConnection.sendRequest(requestBuilder -> {
            requestBuilder.addHeader("Content-Type", "application/json");
            requestBuilder.entity((HttpEntity)new InputStreamHttpEntity((InputStream)new ByteArrayInputStream((" { \"status\" : \"" + notificationStatus + "\" }").getBytes())));
        }, "/notifications/" + notificationId, HttpConstants.Method.PUT);
    }
}

