/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.value.provider;

import com.mulesoft.connectors.cloudhub.internal.CloudHubConnectionProvider;
import com.mulesoft.connectors.cloudhub.internal.CloudHubOperations;
import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.value.provider.BaseValueProvider;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class EnvironmentsValueProvider
extends BaseValueProvider {
    private static final String EXPRESSION = "%dw 2.0\noutput application/java\n---\n(payload.environments map ((key, val) -> {\n    \"$(key.id)\" : key.name\n})) reduce ($$ ++ $)";
    @Parameter
    private String password;
    @Parameter
    private String username;
    @Parameter
    private String anypointPlatformUrl;

    public Set<Value> resolve() throws ValueResolvingException {
        CloudHubConnection cloudHubConnection = new CloudHubConnection(this.username, this.password, null, this.anypointPlatformUrl, this.httpService);
        ConnectionValidationResult validate = new CloudHubConnectionProvider().validate(cloudHubConnection);
        if (!validate.isValid()) {
            throw new ValueResolvingException("Connectivity Issues trying to obtain a connection." + validate.getMessage(), "CONNECTIVITY", (Throwable)validate.getException());
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Reference values = new Reference();
        Reference throwableReference = new Reference();
        new CloudHubOperations().getAccount(cloudHubConnection, this.createCallbackHandler(countDownLatch, (Reference<Set<Value>>)values, (Reference<Throwable>)throwableReference, EXPRESSION));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)e);
        }
        if (throwableReference.get() != null) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)throwableReference.get());
        }
        return (Set)values.get();
    }
}

