/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubTokenException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.internal.config.OAuthDancerConfig;

public final class CloudHubClientCredentialsConnection
extends CloudHubConnection {
    private final ClientCredentialsOAuthDancer dancer;
    private final OAuthDancerConfig config;

    public CloudHubClientCredentialsConnection(ClientCredentialsOAuthDancer dancer, OAuthDancerConfig config, HttpClient httpClient, String defaultEnvironment, String anypointPlatformUrl) {
        super(httpClient, defaultEnvironment, anypointPlatformUrl);
        this.dancer = dancer;
        this.config = config;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.dancer != null) {
            try {
                LifecycleUtils.stopIfNeeded((Object)this.dancer);
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CompletableFuture<HttpResponse> sendRequest(Consumer<HttpRequestBuilder> httpRequestBuilderConsumer, String endpoint, HttpConstants.Method method) {
        HttpRequestBuilder builder = this.buildRequest(httpRequestBuilderConsumer, endpoint, method);
        try {
            builder.addHeader("Authorization", "Bearer " + (String)this.dancer.accessToken().get());
        }
        catch (Exception e) {
            LOGGER.error("Could not obtain access token", (Throwable)e);
            throw new CloudHubTokenException("Could not obtain access token");
        }
        return this.httpClient.sendAsync(builder.build());
    }

    public void refreshToken() throws MuleRuntimeException {
        try {
            this.dancer.refreshToken().get();
            LOGGER.info("Token refreshed successfully");
        }
        catch (Exception e) {
            LOGGER.error("Could not refresh token", (Throwable)e);
            throw new CloudHubTokenException("Could not refresh token");
        }
    }
}

