/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection.providers;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubClientCredentialsConnection;
import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.connection.providers.AbstractConnectionProvider;
import com.mulesoft.connectors.cloudhub.internal.connection.utils.OAuthUtils;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubError;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubException;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubTokenException;
import com.mulesoft.connectors.cloudhub.internal.valueprovider.connection.environment.OAuthEnvironmentsValueProvider;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.internal.config.DefaultClientCredentialsOAuthDancerConfig;
import org.mule.runtime.oauth.internal.config.OAuthDancerConfig;

@Alias(value="oauth-client-credentials")
@DisplayName(value="OAuth Client Credentials")
public class ClientCredentialsConnectionProvider
extends AbstractConnectionProvider {
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private LockFactory lockProvider;
    @Inject
    private MuleExpressionLanguage expressionEvaluator;
    @Parameter
    private String clientId;
    @Parameter
    @Password
    private String clientSecret;
    @Parameter
    @OfValues(value=OAuthEnvironmentsValueProvider.class)
    @Optional
    protected String environment;

    @Override
    public CloudHubConnection connect() {
        this.httpClient = this.createClient(this.httpService);
        DefaultClientCredentialsOAuthDancerConfig config = (DefaultClientCredentialsOAuthDancerConfig)OAuthUtils.setOAuthContext((OAuthDancerConfig)OAuthUtils.createClientCredentialsConfig(this.clientId, this.clientSecret, this.anypointPlatformUrl), this.httpClient, this.schedulerService, this.lockProvider, this.expressionEvaluator);
        Object dancer = OAuthUtils.createDancer(config, this.httpService);
        return new CloudHubClientCredentialsConnection((ClientCredentialsOAuthDancer)dancer, (OAuthDancerConfig)config, this.httpClient, this.environment, this.anypointPlatformUrl);
    }

    @Override
    public ConnectionValidationResult validate(CloudHubConnection connection) {
        ConnectionValidationResult validate = super.validate(connection);
        if (!validate.isValid() && validate.getException() instanceof CloudHubException && ((CloudHubException)((Object)validate.getException())).getType().equals((Object)CloudHubError.INVALID_CREDENTIALS)) {
            try {
                ((CloudHubClientCredentialsConnection)connection).refreshToken();
                validate = super.validate(connection);
            }
            catch (CloudHubTokenException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)((Object)e));
                return validate;
            }
        }
        return validate;
    }
}

