/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.valueprovider;

import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.http.api.HttpService;

public abstract class BaseValueProvider
implements ValueProvider {
    @Inject
    protected HttpService httpService;
    @Inject
    protected SchedulerService schedulerService;
    @Inject
    protected ExpressionManager expressionManager;

    protected CompletionCallback<InputStream, Void> createCallbackHandler(final CountDownLatch countDownLatch, final Reference<Set<Value>> values, final Reference<Throwable> throwableReference, final String expression) {
        return new CompletionCallback<InputStream, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void success(Result<InputStream, Void> result) {
                CountDownLatch transformationLatch = new CountDownLatch(1);
                Scheduler scheduler = BaseValueProvider.this.schedulerService.cpuLightScheduler();
                scheduler.execute(() -> {
                    try {
                        TypedValue payload = BaseValueProvider.this.expressionManager.evaluate(expression, BindingContext.builder().addBinding("payload", BaseValueProvider.this.getTypedValue((Result<InputStream, Void>)result)).build());
                        Map value = (Map)payload.getValue();
                        values.set((Object)ValueBuilder.getValuesFor((Map)(value == null ? Collections.emptyMap() : value)));
                    }
                    finally {
                        transformationLatch.countDown();
                    }
                });
                try {
                    transformationLatch.await();
                }
                catch (InterruptedException e) {
                    throwableReference.set((Object)e);
                }
                finally {
                    scheduler.stop();
                    scheduler = null;
                    countDownLatch.countDown();
                }
            }

            public void error(Throwable throwable) {
                throwableReference.set((Object)throwable);
                countDownLatch.countDown();
            }
        };
    }

    private TypedValue getTypedValue(Result<InputStream, Void> result) {
        InputStream output = (InputStream)result.getOutput();
        String s = IOUtils.toString((InputStream)output);
        return new TypedValue((Object)s, DataType.builder().type(InputStream.class).mediaType((MediaType)result.getMediaType().get()).build());
    }
}

