/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubTokenException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.state.DancerState;

public class CloudHubClientCredentialsConnection
extends CloudHubConnection {
    private final ClientCredentialsOAuthDancer dancer;
    private Instant expirationDate;

    public CloudHubClientCredentialsConnection(ClientCredentialsOAuthDancer dancer, HttpClient httpClient, String defaultEnvironment, String anypointPlatformUrl) {
        super(httpClient, defaultEnvironment, anypointPlatformUrl);
        this.dancer = dancer;
        this.updateExpirationDate();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.dancer != null) {
            try {
                this.dancer.invalidateContext();
                LifecycleUtils.stopIfNeeded((Object)this.dancer);
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CompletableFuture<HttpResponse> sendRequest(Consumer<HttpRequestBuilder> httpRequestBuilderConsumer, String endpoint, HttpConstants.Method method) {
        HttpRequestBuilder builder = this.buildRequest(httpRequestBuilderConsumer, endpoint, method);
        try {
            builder.addHeader("Authorization", "Bearer " + this.getAccessToken());
        }
        catch (Exception e) {
            LOGGER.error("Could not obtain access token", (Throwable)e);
            throw new CloudHubTokenException("Could not obtain access token");
        }
        return this.httpClient.sendAsync(builder.build());
    }

    public void refreshToken() throws MuleRuntimeException {
        try {
            this.dancer.refreshToken().get();
            this.updateExpirationDate();
            LOGGER.info("Token refreshed successfully");
        }
        catch (Exception e) {
            LOGGER.error("Could not refresh token", (Throwable)e);
            throw new CloudHubTokenException("Could not refresh token");
        }
    }

    private void updateExpirationDate() {
        if (this.dancer != null && this.dancer.getContext().getDancerState().equals((Object)DancerState.HAS_TOKEN)) {
            this.expirationDate = Instant.now().plusSeconds(Long.parseLong(this.dancer.getContext().getExpiresIn())).minus(2L, ChronoUnit.MINUTES);
        }
    }

    private String getAccessToken() {
        try {
            if (this.isTokenExpired()) {
                this.refreshToken();
            }
            return (String)this.dancer.accessToken().get();
        }
        catch (Exception e) {
            LOGGER.error("Could not obtain access token", (Throwable)e);
            throw new CloudHubTokenException("Could not obtain access token");
        }
    }

    public boolean isTokenExpired() {
        return this.expirationDate != null && Instant.now().isAfter(this.expirationDate);
    }
}

