/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.commons.template.metadata;

import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mule.connectors.atlantic.commons.builder.clazz.ClassBuilder;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;

public class ConnectorMetadataResolver<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection, SERVICE extends ConnectorService> {
    private final BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor;

    protected ConnectorMetadataResolver(BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor) {
        this.serviceConstructor = serviceConstructor;
    }

    protected ConnectorMetadataResolver(Class<SERVICE> serviceClass) {
        this(serviceClass, clazz -> {
            try {
                return Class.forName(String.format("%sImpl", serviceClass.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected ConnectorMetadataResolver(Class<SERVICE> serviceClass, Function<Class<SERVICE>, Class<? extends SERVICE>> transformer) {
        this((config, connection) -> (ConnectorService)Stream.of(Optional.of(serviceClass).filter(Class::isInterface).map(transformer).orElse(serviceClass).getDeclaredConstructors()).filter(constructor -> ConnectorConfig.class.isAssignableFrom(constructor.getParameterTypes()[0]) && ConnectorConnection.class.isAssignableFrom(constructor.getParameterTypes()[1])).findFirst().orElseThrow(NoSuchMethodException::new).newInstance(config, connection));
    }

    protected ExecutionBuilder<SERVICE> newExecutionBuilder(MetadataContext metadataContext) throws ConnectionException {
        return new ClassBuilder().create(this.serviceConstructor).withParam(metadataContext.getConfig().get()).withParam(metadataContext.getConnection().get());
    }
}

